% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_isochrone.R
\name{get_isochrone}
\alias{get_isochrone}
\title{Compute isochrones/isodistances from nodes.}
\usage{
get_isochrone(Graph, from, lim, setdif = FALSE, keep = NULL, long = FALSE)
}
\arguments{
\item{Graph}{An object generated by \link{makegraph} or \link{cpp_simplify} function.}

\item{from}{numeric or character. A vector of one or more vertices from which isochrones/isodistances are calculated.}

\item{lim}{numeric. A vector of one or multiple breaks.}

\item{setdif}{logical. If \code{TRUE} and \code{length(lim) > 1}, nodes that are reachable in a given break will not appear in a greater one.}

\item{keep}{numeric or character. Vertices of interest that will be returned.}

\item{long}{logical. If \code{TRUE}, a long \code{data.frame} is returned instead of a \code{list}.}
}
\value{
\code{list} or a \code{data.frame} containing reachable nodes below cost limit(s).
}
\description{
Compute isochrones/isodistances from nodes.
}
\details{
If \code{length(lim) > 1}, value is a \code{list} of \code{length(from)}, containing \code{list}s of \code{length(lim)}.

All algorithms are \strong{multithreaded.} Please use \code{RcppParallel::setThreadOptions()} to set the number of threads.

For large graph, \code{keep} argument can be used for saving memory.
}
\note{
\code{get_isochrone()} recursively perform Dijkstra algorithm for each \code{from} nodes and stop when cost limit is reached.
}
\examples{
#Choose number of cores used by cppRouting
RcppParallel::setThreadOptions(numThreads = 1)

#Data describing edges of the graph
edges<-data.frame(from_vertex=c(0,0,1,1,2,2,3,4,4),
                  to_vertex=c(1,3,2,4,4,5,1,3,5),
                  cost=c(9,2,11,3,5,12,4,1,6))

#Construct directed graph
directed_graph<-makegraph(edges,directed=TRUE)

#Get nodes reachable around node 4 with maximum distances of 1 and 2
iso<-get_isochrone(Graph=directed_graph,from = "4",lim=c(1,2))

#With setdif set to TRUE
iso2<-get_isochrone(Graph=directed_graph,from = "4",lim=c(1,2),setdif=TRUE)
print(iso)
print(iso2)
}
