% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teststats.R
\name{qscore_stat}
\alias{qscore_stat}
\title{Calculates the randomisation test statistic}
\usage{
qscore_stat(
  fit,
  data,
  null_par = 0,
  tr_var = "treat",
  cl_var = "cl",
  tr_assign = "treat"
)
}
\arguments{
\item{fit}{A glm or lm model fit}

\item{data}{The data frame used to fit model fit}

\item{null_par}{Numeric the value of tr_var parameter under the null hypothesis}

\item{tr_var}{String indicating the name of the column in data that is a binary indicator
for whether the observation was under the treatment (1=treatment, 0=control)}

\item{cl_var}{String specifying the name of the column identifying the clusters/cluster-time}

\item{tr_assign}{String specifying the treatment assignment under a new permutation. If calculating
the test statistics under the original treatment assignment then this should be the same
as tr_var}
}
\value{
The value of the test statistic
}
\description{
Calculates a randomisation test statistic based on the sum of generalised, studentized
residuals for a given model fit and null hypothesis of the value of the treatment effect
parameter
}
\examples{
out <- twoarm_sim()
data <- out[[1]]
  fit1 <- glm(y1 ~ treat ,
              data=data,
              family="poisson")
qscore_stat(fit=fit1,
            data=data)
}
