% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_definition_aws_batch.R
\name{crew_definition_aws_batch}
\alias{crew_definition_aws_batch}
\title{Create an AWS Batch job definition object.}
\usage{
crew_definition_aws_batch(
  job_queue,
  job_definition = paste0("crew-aws-batch-job-definition-", crew::crew_random_name()),
  log_group = "/aws/batch/job",
  config = NULL,
  credentials = NULL,
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{job_queue}{Character of length 1, name of the AWS Batch
job queue.}

\item{job_definition}{Character of length 1, name of the AWS Batch
job definition. The job definition might or might not exist
at the time \code{crew_definition_aws_batch()} is called. Either way is fine.}

\item{log_group}{Character of length 1,
AWS Batch CloudWatch log group to get job logs.
The default log group is often \code{"/aws/batch/job"}, but not always.
It is not easy to get the log group of an active job or job
definition, so if you have a non-default log group and you do not
know its name, please consult your system administrator.}

\item{config}{Optional named list, \code{config} argument of
\code{paws.compute::batch()} with optional configuration details.}

\item{credentials}{Optional named list. \code{credentials} argument of
\code{paws.compute::batch()} with optional credentials (if not already
provided through environment variables such as \code{AWS_ACCESS_KEY_ID}).}

\item{endpoint}{Optional character of length 1. \code{endpoint}
argument of \code{paws.compute::batch()} with the endpoint to send HTTP
requests.}

\item{region}{Character of length 1. \code{region} argument of
\code{paws.compute::batch()} with an AWS region string such as \code{"us-east-2"}.
Serves as the region for both AWS Batch and CloudWatch. Tries to
default to \code{paws.common::get_config()$region}, then to
\code{Sys.getenv("AWS_REGION")} if unsuccessful, then
\code{Sys.getenv("AWS_REGION")}, then \code{Sys.getenv("AWS_DEFAULT_REGION")}.}
}
\description{
Create an \code{R6} object to manage a job definition for AWS
Batch jobs.
}
\seealso{
Other definition: 
\code{\link{crew_class_definition_aws_batch}}
}
\concept{definition}
