% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_controller_group.R
\name{crew_class_controller_group}
\alias{crew_class_controller_group}
\title{Controller group class}
\description{
\code{R6} class for controller groups.
}
\details{
See \code{\link[=crew_controller_group]{crew_controller_group()}}.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
crew_session_start()
persistent <- crew_controller_callr(name = "persistent")
transient <- crew_controller_callr(
  name = "transient",
  max_tasks = 1L
)
group <- crew_controller_group(persistent, transient)
group$connect()
group$push(name = "task", command = sqrt(4), controller = "transient")
group$wait()
group$pop()
group$controllers[["persistent"]]$launcher$running() # 0
group$controllers[["transient"]]$launcher$running() # 0
group$terminate()
crew_session_terminate()
}

## ------------------------------------------------
## Method `crew_class_controller_group$new`
## ------------------------------------------------

if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
crew_session_start()
persistent <- crew_controller_callr(name = "persistent")
transient <- crew_controller_callr(
  name = "transient",
  max_tasks = 1L
)
group <- crew_controller_group(persistent, transient)
group$connect()
group$push(name = "task", command = sqrt(4), controller = "transient")
group$wait()
group$pop()
group$controllers[["persistent"]]$launcher$running() # 0
group$controllers[["transient"]]$launcher$running() # 0
group$terminate()
crew_session_terminate()
}
}
\seealso{
Other controllers: 
\code{\link{crew_class_controller}},
\code{\link{crew_controller_callr}()},
\code{\link{crew_controller_group}()},
\code{\link{crew_controller}()}
}
\concept{controllers}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{controllers}}{List of \code{R6} controller objects.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_controller_group-new}{\code{crew_class_controller_group$new()}}
\item \href{#method-crew_class_controller_group-validate}{\code{crew_class_controller_group$validate()}}
\item \href{#method-crew_class_controller_group-start}{\code{crew_class_controller_group$start()}}
\item \href{#method-crew_class_controller_group-launch}{\code{crew_class_controller_group$launch()}}
\item \href{#method-crew_class_controller_group-scale}{\code{crew_class_controller_group$scale()}}
\item \href{#method-crew_class_controller_group-collect}{\code{crew_class_controller_group$collect()}}
\item \href{#method-crew_class_controller_group-push}{\code{crew_class_controller_group$push()}}
\item \href{#method-crew_class_controller_group-pop}{\code{crew_class_controller_group$pop()}}
\item \href{#method-crew_class_controller_group-wait}{\code{crew_class_controller_group$wait()}}
\item \href{#method-crew_class_controller_group-summary}{\code{crew_class_controller_group$summary()}}
\item \href{#method-crew_class_controller_group-terminate}{\code{crew_class_controller_group$terminate()}}
\item \href{#method-crew_class_controller_group-clone}{\code{crew_class_controller_group$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-new}{}}}
\subsection{Method \code{new()}}{
Multi-controller constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$new(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{List of \code{R6} controller objects.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{R6} object with the controller group object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
crew_session_start()
persistent <- crew_controller_callr(name = "persistent")
transient <- crew_controller_callr(
  name = "transient",
  max_tasks = 1L
)
group <- crew_controller_group(persistent, transient)
group$connect()
group$push(name = "task", command = sqrt(4), controller = "transient")
group$wait()
group$pop()
group$controllers[["persistent"]]$launcher$running() # 0
group$controllers[["transient"]]$launcher$running() # 0
group$terminate()
crew_session_terminate()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the router.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-start"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-start}{}}}
\subsection{Method \code{start()}}{
Start one or more controllers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$start(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-launch"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-launch}{}}}
\subsection{Method \code{launch()}}{
Launch one or more workers on one or more controllers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$launch(n = 1L, controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of workers to launch in each controller selected.}

\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-scale"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-scale}{}}}
\subsection{Method \code{scale()}}{
Automatically scale up the number of workers if needed
in one or more controller objects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$scale(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See the \code{scale()} method in individual controller classes.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-collect"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-collect}{}}}
\subsection{Method \code{collect()}}{
Check for done tasks and move the results to
the results list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$collect(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly). Removes elements from the \code{queue}
list as applicable and moves them to the \code{results} list.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-push"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-push}{}}}
\subsection{Method \code{push()}}{
Push a task to the head of the task list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$push(
  command,
  data = list(),
  globals = list(),
  seed = sample.int(n = 1000000000L, size = 1L),
  garbage_collection = FALSE,
  packages = character(0),
  library = NULL,
  seconds_timeout = NULL,
  name = NULL,
  scale = TRUE,
  controller = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{command}}{Language object with R code to run.}

\item{\code{data}}{Named list of local data objects in the
evaluation environment.}

\item{\code{globals}}{Named list of objects to temporarily assign to the
global environment for the task. At the end of the task,
these values are reset to their previous values.}

\item{\code{seed}}{Integer of length 1 with the pseudo-random number generator
seed to temporarily set for the evaluation of the task.
At the end of the task, the seed is restored.}

\item{\code{garbage_collection}}{Logical, whether to run garbage collection
with \code{gc()} before running the task.}

\item{\code{packages}}{Character vector of packages to load for the task.}

\item{\code{library}}{Library path to load the packages. See the \code{lib.loc}
argument of \code{require()}.}

\item{\code{seconds_timeout}}{Optional task timeout passed to the \code{.timeout}
argument of \code{mirai::mirai()} (after converting to milliseconds).}

\item{\code{name}}{Optional name of the task. Replaced with a random name
if \code{NULL} or in conflict with an existing name in the task list.}

\item{\code{scale}}{Logical, whether to automatically scale workers to meet
demand. If \code{TRUE}, then \code{clean()} and \code{collect()} run first
so demand can be properly assessed before scaling and the number
of workers is not too high.}

\item{\code{controller}}{Character of length 1,
name of the controller to submit the task.
If \code{NULL}, the controller defaults to the
first controller in the list.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-pop"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-pop}{}}}
\subsection{Method \code{pop()}}{
Pop a completed task from the results data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$pop(scale = TRUE, controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scale}}{Logical, whether to automatically scale workers to meet
demand. If \code{TRUE}, then \code{clean()} and \code{collect()} run first
so demand can be properly assessed before scaling and the number
of workers is not too high. Scaling up on \code{pop()} may be important
for transient or nearly transient workers that tend to drop off
quickly after doing little work.}

\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If there is a completed task available to collect, the return
value is a one-row data frame with the results, warnings, and errors.
Otherwise, if there are no results available to collect,
the return value is \code{NULL}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-wait"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-wait}{}}}
\subsection{Method \code{wait()}}{
Wait for tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$wait(
  mode = "all",
  seconds_interval = 0.001,
  seconds_timeout = Inf,
  controllers = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mode}}{If \code{mode} is \code{"all"},
then the method waits for all tasks to complete. If \code{mode} is
\code{"one"}, then it waits until a one task is complete.}

\item{\code{seconds_interval}}{Number of seconds to wait between
polling intervals while checking for results.}

\item{\code{seconds_timeout}}{Timeout length in seconds waiting for
results to become available.}

\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The \code{wait()} method blocks the calling R session,
repeatedly auto-scales workers for tasks
that need them, and repeatedly collects results.
The function runs until it either times out or one of the
controllers reaches the stopping condition
based on the \code{mode} argument.
}

\subsection{Returns}{
\code{NULL} (invisibly). Call \code{pop()} to get the result.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-summary"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-summary}{}}}
\subsection{Method \code{summary()}}{
Summarize the workers of one or more controllers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$summary(
  columns = tidyselect::everything(),
  controllers = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{columns}}{Tidyselect expression to select a subset of columns.
Examples include \code{columns = contains("worker")} and
\code{columns = starts_with("tasks")}.}

\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame of aggregated worker summary statistics
of all the selected controllers. It has one row per worker
websocket, and the rows are grouped by controller.
See the documentation of the \code{summary()} method of the controller
class for specific information about the columns in the output.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-terminate}{}}}
\subsection{Method \code{terminate()}}{
Terminate the workers and disconnect the router
for one or more controllers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$terminate(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Character vector of controller names.
Set to \code{NULL} to select all controllers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_group-clone"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_group-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_group$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
