% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_router.R
\name{crew_class_router}
\alias{crew_class_router}
\title{Router class}
\description{
\code{R6} class for \code{mirai} routers.
}
\details{
See \code{\link[=crew_router]{crew_router()}}.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
router <- crew_router()
router$listen()
router$daemons
router$terminate()
}

## ------------------------------------------------
## Method `crew_class_router$new`
## ------------------------------------------------

if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
router <- crew_router()
router$listen()
router$daemons
router$terminate()
}
}
\seealso{
Other routers: 
\code{\link{crew_router}()}
}
\concept{routers}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{See \code{\link[=crew_router]{crew_router()}}.}

\item{\code{workers}}{See \code{\link[=crew_router]{crew_router()}}.}

\item{\code{host}}{See \code{\link[=crew_router]{crew_router()}}.}

\item{\code{port}}{See \code{\link[=crew_router]{crew_router()}}.}

\item{\code{seconds_interval}}{See \code{\link[=crew_router]{crew_router()}}.}

\item{\code{seconds_timeout}}{See \code{\link[=crew_router]{crew_router()}}.}

\item{\code{dispatcher}}{Process ID of the \code{mirai} dispatcher}

\item{\code{daemons}}{Data frame of information from \code{mirai::daemons()}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_router-new}{\code{crew_class_router$new()}}
\item \href{#method-crew_class_router-validate}{\code{crew_class_router$validate()}}
\item \href{#method-crew_class_router-listening}{\code{crew_class_router$listening()}}
\item \href{#method-crew_class_router-listen}{\code{crew_class_router$listen()}}
\item \href{#method-crew_class_router-poll}{\code{crew_class_router$poll()}}
\item \href{#method-crew_class_router-terminate}{\code{crew_class_router$terminate()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_router-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_router-new}{}}}
\subsection{Method \code{new()}}{
\code{mirai} router constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_router$new(
  name = NULL,
  workers = NULL,
  host = NULL,
  port = NULL,
  seconds_interval = NULL,
  seconds_timeout = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Argument passed from \code{\link[=crew_router]{crew_router()}}.}

\item{\code{workers}}{Argument passed from \code{\link[=crew_router]{crew_router()}}.}

\item{\code{host}}{Argument passed from \code{\link[=crew_router]{crew_router()}}.}

\item{\code{port}}{Argument passed from \code{\link[=crew_router]{crew_router()}}.}

\item{\code{seconds_interval}}{Argument passed from \code{\link[=crew_router]{crew_router()}}.}

\item{\code{seconds_timeout}}{Argument passed from \code{\link[=crew_router]{crew_router()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{R6} object with the router.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
router <- crew_router()
router$listen()
router$daemons
router$terminate()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_router-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_router-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the router.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_router$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_router-listening"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_router-listening}{}}}
\subsection{Method \code{listening()}}{
Check if the \code{mirai} client is listening
to worker websockets.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_router$listening()}\if{html}{\out{</div>}}
}

\subsection{Details}{
This method may stall and time out if there are
tasks in the queue. Methods \code{listen()} and \code{terminate()}
call \code{listening()} to manage the connection before
and after the entire workload, respectively.
}

\subsection{Returns}{
\code{TRUE} if successfully listening for dialed-in workers,
\code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_router-listen"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_router-listen}{}}}
\subsection{Method \code{listen()}}{
Start listening for workers on the available sockets.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_router$listen()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_router-poll"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_router-poll}{}}}
\subsection{Method \code{poll()}}{
Update the \code{daemons} field with
information on the \code{mirai} daemons.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_router$poll()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Call \code{mirai::daemons()} to get information about the workers.
If the workers cannot be reached or the router has not started,
then do not modify the \code{daemons} field. Otherwise, if the workers
are reachable, populate the \code{daemons} field with a data frame
of high-level worker-specific statistics.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_router-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_router-terminate}{}}}
\subsection{Method \code{terminate()}}{
Stop the mirai client and disconnect from the
worker websockets.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_router$terminate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
}
