% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_launcher_local.R
\name{crew_launcher_local}
\alias{crew_launcher_local}
\title{Create a launcher with local process workers.}
\usage{
crew_launcher_local(
  name = NULL,
  seconds_interval = 0.5,
  seconds_timeout = 60,
  seconds_launch = 30,
  seconds_idle = Inf,
  seconds_wall = Inf,
  seconds_exit = NULL,
  tasks_max = Inf,
  tasks_timers = 0L,
  reset_globals = TRUE,
  reset_packages = FALSE,
  reset_options = FALSE,
  garbage_collection = FALSE,
  crashes_error = 5L,
  launch_max = NULL,
  tls = crew::crew_tls(),
  r_arguments = c("--no-save", "--no-restore"),
  options_metrics = crew::crew_options_metrics(),
  options_local = crew::crew_options_local(),
  local_log_directory = NULL,
  local_log_join = NULL
)
}
\arguments{
\item{name}{Name of the launcher.}

\item{seconds_interval}{Number of seconds between
polling intervals waiting for certain internal
synchronous operations to complete,
such as checking \code{mirai::status()}.}

\item{seconds_timeout}{Number of seconds until timing
out while waiting for certain synchronous operations to complete,
such as checking \code{mirai::status()}.}

\item{seconds_launch}{Seconds of startup time to allow.
A worker is unconditionally assumed to be alive
from the moment of its launch until \code{seconds_launch} seconds later.
After \code{seconds_launch} seconds, the worker is only
considered alive if it is actively connected to its assign websocket.}

\item{seconds_idle}{Maximum number of seconds that a worker can idle
since the completion of the last task. If exceeded, the worker exits.
But the timer does not launch until \code{tasks_timers} tasks
have completed.
See the \code{idletime} argument of \code{mirai::daemon()}. \code{crew} does not
excel with perfectly transient workers because it does not micromanage
the assignment of tasks to workers, so please allow enough idle
time for a new worker to be delegated a new task.}

\item{seconds_wall}{Soft wall time in seconds.
The timer does not launch until \code{tasks_timers} tasks
have completed.
See the \code{walltime} argument of \code{mirai::daemon()}.}

\item{seconds_exit}{Deprecated on 2023-09-21 in version 0.5.0.9002.
No longer necessary.}

\item{tasks_max}{Maximum number of tasks that a worker will do before
exiting. See the \code{maxtasks} argument of \code{mirai::daemon()}.
\code{crew} does not
excel with perfectly transient workers because it does not micromanage
the assignment of tasks to workers, it is recommended to set
\code{tasks_max} to a value greater than 1.}

\item{tasks_timers}{Number of tasks to do before activating
the timers for \code{seconds_idle} and \code{seconds_wall}.
See the \code{timerstart} argument of \code{mirai::daemon()}.}

\item{reset_globals}{\code{TRUE} to reset global environment
variables between tasks, \code{FALSE} to leave them alone.}

\item{reset_packages}{\code{TRUE} to unload any packages loaded during
a task (runs between each task), \code{FALSE} to leave packages alone.}

\item{reset_options}{\code{TRUE} to reset global options to their original
state between each task, \code{FALSE} otherwise. It is recommended to
only set \code{reset_options = TRUE} if \code{reset_packages} is also \code{TRUE}
because packages sometimes rely on options they set at loading time.}

\item{garbage_collection}{\code{TRUE} to run garbage collection between
tasks, \code{FALSE} to skip.}

\item{crashes_error}{Positive integer scalar. If a worker exits
\code{crashes_error} times in a row without completing all its assigned
tasks, then the launcher throws an informative error.
The reason for \code{crashes_error}
is to avoid an infinite loop where a task crashes a worker
(through a segfault, maxing out memory, etc) but the worker always
relaunches. To monitor the resources of \code{crew} workers,
please see \url{https://wlandau.github.io/crew/articles/logging.html}.}

\item{launch_max}{Deprecated on 2024-11-04 (version 0.10.1.9000).
Use \code{crashes_error} instead.}

\item{tls}{A TLS configuration object from \code{\link[=crew_tls]{crew_tls()}}.}

\item{r_arguments}{Optional character vector of command line arguments
to pass to \code{Rscript} (non-Windows) or \code{Rscript.exe} (Windows)
when starting a worker. Example:
\code{r_arguments = c("--vanilla", "--max-connections=32")}.}

\item{options_metrics}{Either \code{NULL} to opt out of resource metric logging
for workers, or an object from \code{\link[=crew_options_metrics]{crew_options_metrics()}} to enable
and configure resource metric logging for workers.
For resource logging to run,
the \code{autometric} R package version 0.1.0 or higher
must be installed.}

\item{options_local}{An object generated by \code{\link[=crew_options_local]{crew_options_local()}}
with options specific to the local controller.}

\item{local_log_directory}{Deprecated on 2024-10-08. Use
\code{options_local} instead.}

\item{local_log_join}{Deprecated on 2024-10-08. Use
\code{options_local} instead.}
}
\description{
Create an \code{R6} object to launch and maintain
local process workers.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
client$start()
launcher <- crew_launcher_local(name = client$name)
launcher$start(sockets = client$summary()$socket)
launcher$launch(index = 1L)
task <- mirai::mirai("result", .compute = client$name)
mirai::call_mirai_(task)
task$data
client$terminate()
}
}
\seealso{
Other plugin_local: 
\code{\link{crew_class_launcher_local}},
\code{\link{crew_controller_local}()}
}
\concept{plugin_local}
