% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/caseUtils.R
\name{getCrimes}
\alias{getCrimes}
\title{Generate a list of crimes for a specific offender}
\usage{
getCrimes(offenderID, crimedata, offenderTable)
}
\arguments{
\item{offenderID}{an offender ID that is in \code{offenderTable}}

\item{crimedata}{data.frame of crime incident data. \code{crimedata} must be
  a data.frame with a column named: \code{crimeID}}

\item{offenderTable}{offender table that indicates the offender(s) responsible
  for solved crimes. \code{offenderTable} must have columns named:
  \code{offenderID} and \code{crimeID}.}
}
\value{
The subset of crimes in \code{crimedata} that are attributable to
   the offender named \code{offenderID}
}
\description{
Generate a list of crimes for a specific offender
}
\examples{
data(crimes)
 data(offenders)

 getCrimes("O:40",crimes,offenders)
}
\seealso{
\code{\link{getCrimeSeries}}
}

