% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{ProbitLogNormal-class}
\alias{.ProbitLogNormal}
\alias{ProbitLogNormal-class}
\title{Probit model with bivariate log normal prior}
\description{
This is probit regression model with a bivariate normal prior on
the intercept and log slope. 
The covariate is the dose \eqn{x} itself for this class:
}
\details{
\deqn{probit[p(x)] = \alpha + \beta \cdot x}
where \eqn{p(x)} is the probability of observing a DLT for a given dose
\eqn{x}.

The prior is
\deqn{(\alpha, \log(\beta)) \sim Normal(\mu, \Sigma)}

The slots of this class contain the mean vector and the covariance matrix of
the bivariate normal distribution, as well as the reference dose.
Note that the parametrization inside the class uses alpha0 and alpha1.

This model is also used in the \code{\linkS4class{DualEndpoint}} classes,
so this class can be used to check the prior assumptions on the dose-toxicity
model - even when sampling from the prior distribution of the dual endpoint model
is not possible.
}
\section{Slots}{

\describe{
\item{\code{mu}}{the prior mean vector \eqn{\mu}}

\item{\code{Sigma}}{the prior covariance matrix \eqn{\Sigma}}
}}
\examples{


model <- ProbitLogNormal(mu = c(-0.85, 1),
                           Sigma = matrix(c(1, -0.5, -0.5, 1), nrow = 2))


}
\keyword{classes}

