% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fromQuantiles.R
\name{Quantiles2LogisticNormal}
\alias{Quantiles2LogisticNormal}
\title{Convert prior quantiles (lower, median, upper) to logistic (log)
normal model}
\usage{
Quantiles2LogisticNormal(
  dosegrid,
  refDose,
  lower,
  median,
  upper,
  level = 0.95,
  logNormal = FALSE,
  parstart = NULL,
  parlower = c(-10, -10, 0, 0, -0.95),
  parupper = c(10, 10, 10, 10, 0.95),
  seed = 12345,
  verbose = TRUE,
  control = list(threshold.stop = 0.01, maxit = 50000, temperature = 50000, max.time =
    600)
)
}
\arguments{
\item{dosegrid}{the dose grid}

\item{refDose}{the reference dose}

\item{lower}{the lower quantiles}

\item{median}{the medians}

\item{upper}{the upper quantiles}

\item{level}{the credible level of the (lower, upper) intervals (default:
0.95)}

\item{logNormal}{use the log-normal prior? (not default) otherwise, the
normal prior for the logistic regression coefficients is used}

\item{parstart}{starting values for the parameters. By default, these
are determined from the medians supplied.}

\item{parlower}{lower bounds on the parameters (intercept alpha and the
slope beta, the corresponding standard deviations and the correlation.)}

\item{parupper}{upper bounds on the parameters}

\item{seed}{seed for random number generation}

\item{verbose}{be verbose? (default)}

\item{control}{additional options for the optimisation routine, see
\code{\link[GenSA]{GenSA}} for more details}
}
\value{
a list with the best approximating \code{model}
(\code{\linkS4class{LogisticNormal}} or
\code{\linkS4class{LogisticLogNormal}}), the resulting \code{quantiles}, the
\code{required} quantiles and the \code{distance} to the required quantiles,
as well as the final \code{parameters} (which could be used for running the
algorithm a second time)
}
\description{
This function uses generalised simulated annealing to optimise
a \code{\linkS4class{LogisticNormal}} model to be as close as possible
to the given prior quantiles.
}
\keyword{programming}
