% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{ModelLogNormal-class}
\alias{ModelLogNormal-class}
\alias{.ModelLogNormal}
\alias{ModelLogNormal}
\alias{.DefaultModelLogNormal}
\title{\code{ModelLogNormal}}
\usage{
ModelLogNormal(mean, cov, ref_dose = 1)

.DefaultModelLogNormal()
}
\arguments{
\item{mean}{(\code{numeric})\cr the prior mean vector.}

\item{cov}{(\code{matrix})\cr the prior covariance matrix. The precision matrix
\code{prec} is internally calculated as an inverse of \code{cov}.}

\item{ref_dose}{(\code{number})\cr the reference dose \eqn{x*} (strictly positive
number).}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{ModelLogNormal}} is the class for a model with a reference dose and bivariate
normal prior on the model parameters \code{alpha0} and natural logarithm of \code{alpha1},
i.e.: \deqn{(alpha0, log(alpha1)) ~ Normal(mean, cov),}. Transformations other
than \code{log}, e.g. identity, can be specified too in \code{priormodel} slot.
The parameter \code{alpha1} has a log-normal distribution by default to ensure
positivity of \code{alpha1} which further guarantees \code{exp(alpha1) > 1}.
The slots of this class contain the mean vector, the covariance and
precision matrices of the bivariate normal distribution, as well as the
reference dose. Note that the precision matrix is an inverse of the
covariance matrix in the \code{JAGS}.
All ("normal") model specific classes inherit from this class.
}
\section{Slots}{

\describe{
\item{\code{params}}{(\code{ModelParamsNormal})\cr bivariate normal prior parameters.}

\item{\code{ref_dose}}{(\code{positive_number})\cr the reference dose.}
}}

\note{
Typically, end users will not use the \code{.DefaultModelLogNormal()} function.
}
\seealso{
\code{\link{ModelParamsNormal}}, \code{\link{LogisticNormal}}, \code{\link{LogisticLogNormal}},
\code{\link{LogisticLogNormalSub}}, \code{\link{ProbitLogNormal}}, \code{\link{ProbitLogNormalRel}}.
}
