% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cron_rscript.R
\name{cron_rscript}
\alias{cron_rscript}
\title{Create a command to execute an R script which can be scheduled with cron_add}
\usage{
cron_rscript(
  rscript,
  rscript_log = sprintf("\%s\%s.log", tools::file_path_sans_ext(rscript),
    ifelse(log_timestamp, "-`date+\\\\\%Y-\\\\\%m-\\\\\%d_\\\\\%H:\\\\\%M:\\\\\%S`", "")),
  rscript_args = "",
  cmd = file.path(Sys.getenv("R_HOME"), "bin", "Rscript"),
  log_append = TRUE,
  log_timestamp = FALSE,
  workdir = NULL
)
}
\arguments{
\item{rscript}{character string with the path to an R script with .r or .R extension}

\item{rscript_log}{where to put the log, defaults in the same directory and with the same filename as \code{rscript} but with  extension .log.}

\item{rscript_args}{a character string with extra arguments to be passed on to Rscript}

\item{cmd}{path to Rscript. Defaults to R_HOME/bin/Rscript}

\item{log_append}{logical, append to the log or overwrite}

\item{log_timestamp}{logical, indicating to append a timestamp to the script log filename in the default argument of \code{rscript_log}. 
This will only work if the path to the log folder does not contain spaces.}

\item{workdir}{If provided, Rscript will be run from this working directory.}
}
\value{
a character string with a command which can e.g. be put as a cronjob for running a simple R script at specific timepoints
}
\description{
Create a command to execute an R script which can be scheduled with cron_add where the stdin and stderr will be passed on to a log
}
\examples{
f <- system.file(package = "cronR", "extdata", "helloworld.R")
cron_rscript(f)
cron_rscript(f, rscript_args = "more arguments passed on to the call")
cron_rscript(f, rscript_args = c("more", "arguments", "passed", "on", "to", "the", "call"))

cron_rscript(f, log_append = FALSE)
cron_rscript(f, log_append = TRUE)
cron_rscript(f, log_append = FALSE, log_timestamp = TRUE)

## run from home directory
cron_rscript(f, workdir = normalizePath("~"))

}
