% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LoadROI.R
\name{loadROI}
\alias{loadROI}
\title{Load image data to do crop water demand
\if{html}{\figure{logo_cropDemand.png}{options: height= 300 width=auto style = float:right alt= Our logo}}}
\usage{
loadROI(variable, region, sub_region)
}
\arguments{
\item{variable}{Stack of evapotranspiration or rainfall (Rasterstack).}

\item{region}{Use the "brazil" shp file to extract the rasterstack (variable) for one state (Brazilian state), or use the "biomes_brazil" to extract the Rasterstack (variable) for one biome of Brazil.}

\item{sub_region}{You have two options in this section, if you choice the brazil (in region parameter) you need to choice the Brazilian states, but if you choice the biomes-brazil (in region parameter) you must choice one of Brazilian biomes.}
}
\value{
Load the reference evapotranspiration (eto) or rainfall (ppt) rasterstack
}
\description{
This fuction will load the evapotranspiration and rainfall data for the region of interest (ROI).
}
\examples{
\dontrun{
#For Brazilian states

see_brazil_states()

image_etp<-loadROI(variable = "eto", region = "brazil",
                    sub_region = 13) # sub_regions 1:27

image_rainfall<-loadROI(variable = "ppt",
                        region = "brazil", sub_region = 13)

#For Brazilian Biomes:

see_brazil_biomes()

image_tmin<- loadROI(variable = "eto", region = "biomes_brazil",
                      sub_region = 2)# sub regions: 1:6 (biomes)

}
}
\references{
The images used in this package can be found in the paper: Abatzoglou, J.T., S.Z. Dobrowski, S.A. Parks, K.C. Hegewisch, 2018, Terraclimate, a high-resolution global dataset of monthly climate and climatic water balance from 1958-2015, Scientific Data.
}
