% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future_xmap.R
\name{future_xmap}
\alias{future_xmap}
\alias{future_xmap_chr}
\alias{future_xmap_dbl}
\alias{future_xmap_dfc}
\alias{future_xmap_dfr}
\alias{future_xmap_int}
\alias{future_xmap_lgl}
\title{Map over each combination of list elements simultaneously via futures}
\usage{
future_xmap(.l, .f, ..., .progress = FALSE, .options = furrr::future_options())

future_xmap_chr(
  .l,
  .f,
  ...,
  .progress = FALSE,
  .options = furrr::future_options()
)

future_xmap_dbl(
  .l,
  .f,
  ...,
  .progress = FALSE,
  .options = furrr::future_options()
)

future_xmap_dfc(
  .l,
  .f,
  ...,
  .progress = FALSE,
  .options = furrr::future_options()
)

future_xmap_dfr(
  .l,
  .f,
  ...,
  .id = NULL,
  .progress = FALSE,
  .options = furrr::future_options()
)

future_xmap_int(
  .l,
  .f,
  ...,
  .progress = FALSE,
  .options = furrr::future_options()
)

future_xmap_lgl(
  .l,
  .f,
  ...,
  .progress = FALSE,
  .options = furrr::future_options()
)
}
\arguments{
\item{.l}{A list of vectors, such as a data frame.
The length of .l determines the number of arguments that .f will be called
with.
List names will be used if present.}

\item{.f}{A function, formula, or vector (not necessarily atomic).

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.

If \strong{character vector}, \strong{numeric vector}, or \strong{list}, it is
converted to an extractor function. Character vectors index by
name and numeric vectors index by position; use a list to index
by position and name at different levels. If a component is not
present, the value of \code{.default} will be returned.}

\item{...}{Additional arguments passed on to \code{.f}}

\item{.progress}{A logical, for whether or not to print a progress bar for
multiprocess, multisession, and multicore plans}

\item{.options}{The \code{future} specific options to use with the workers.
This must be the result from a call to \code{\link[furrr:future_options]{furrr::future_options()}}}

\item{.id}{Either a string or \code{NULL}.
If a string, the output will contain a variable with that name, storing
either the name (if \code{.x} is named) or the index (if \code{.x} is unnamed) of
the input.
If \code{NULL}, the default, no variable will be created.

Only applies to \verb{_dfr} variant.}
}
\value{
An atomic vector, list, or data frame, depending on the suffix.
Atomic vectors and lists will be named if the first element of .l is named.

If all input is length 0, the output will be length 0.
If any input is length 1, it will be recycled to the length of the longest.
}
\description{
These functions work exactly the same as \code{\link[=xmap]{xmap()}} functions,
but allow you to run the map in parallel using \code{\link[future:future]{future::future()}}
}
\examples{
future_xmap(list(1:5, 1:5), ~ .y * .x)
future_xmap_dbl(list(1:5, 1:5), ~ .y * .x)
future_xmap_chr(list(1:5, 1:5), ~ paste(.y, "*", .x, "=", .y * .x))

apples_and_bananas <- list(
  x = c("apples", "bananas"),
  pattern = "a",
  replacement = c("oo", "ee")
)

future_xmap_chr(apples_and_bananas, gsub)

formulas <- list(mpg ~ wt, mpg ~ hp)
subsets  <- split(mtcars, mtcars$cyl)

future_xmap(list(subsets, formulas), ~ lm(.y, data = .x))
}
\seealso{
\code{\link[=xmap]{xmap()}} to run functions without with parallel processing.

\code{\link[=future_xmap_vec]{future_xmap_vec()}} to automatically determine output type.

\code{\link[=future_xmap_mat]{future_xmap_mat()}} and \code{\link[=future_xmap_arr]{future_xmap_arr()}} to return results in a matrix
or array.

\code{\link[furrr:future_map]{furrr::future_map()}}, \code{\link[furrr:future_map2]{furrr::future_map2()}}, and \code{\link[furrr:future_map2]{furrr::future_pmap()}}
for other parallelized mapping functions.
}
