% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect.R
\name{effect_tabular}
\alias{effect_tabular}
\alias{effect_odds_ratio}
\alias{effect_relative_risk}
\alias{effect_risk_difference}
\title{Effect measure for association between two categorical variables}
\usage{
effect_odds_ratio(x, by, conf_level = 0.95)

effect_relative_risk(x, by, conf_level = 0.95)

effect_risk_difference(x, by, conf_level = 0.95)
}
\arguments{
\item{x}{categorical vector (character, factor, ...)}

\item{by}{categorical vector (of exactly 2 unique levels)}

\item{conf_level}{confidence interval level}
}
\value{
A list with five components: effect, ci, effect.name, effect.type, and conf_level
}
\description{
User can either use or extend these functions to configure effect calculation.
}
\section{Functions}{
\itemize{
\item \code{effect_odds_ratio}: (\strong{Default}) calculate the odds ratio

\item \code{effect_relative_risk}: calculate the relative risk

\item \code{effect_risk_difference}: calculate the risk difference
}}

\seealso{
\code{\link[=crosstable_effect_args]{crosstable_effect_args()}}
}
\author{
Dan Chaltiel, David Hajage
}
