% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/officer.R
\name{body_add_normal}
\alias{body_add_normal}
\alias{body_add_glued}
\title{Add a new paragraph with default style}
\usage{
body_add_normal(
  doc,
  ...,
  .sep = "",
  style = NULL,
  squish = TRUE,
  font_size = NA,
  envir = parent.frame(),
  parse = c("ref", "format", "code")
)
}
\arguments{
\item{doc}{the doc object (created with the \code{read_docx} function of \code{officer} package)}

\item{...}{one or several character strings, pasted using \code{.sep}. As with \code{glue::glue()}, expressions enclosed by braces will be evaluated as R code. If more than one variable is passed, all should be of length 1.}

\item{.sep}{Separator used to separate elements.}

\item{style}{Style for normal text. Best set with \code{\link[=crosstable_options]{crosstable_options()}}.}

\item{squish}{Whether to squish the result (remove trailing and repeated spaces). Default to \code{TRUE}. Allows to add multiline paragraph without breaking the string.}

\item{font_size}{Font size.}

\item{envir}{Environment to evaluate each expression in \code{glue()}.}

\item{parse}{which format to parse. Default to all formats (\code{c("ref", "format", "code")}).}
}
\value{
a new doc object

The docx object \code{doc}
}
\description{
Add a new paragraph in an \code{officer} document with default style.\cr
Variables can be inserted in the text as multiple strings (\code{paste()} style) or enclosed by braces (\code{glue()} style).  \cr
Basic markdown syntax is available: \verb{**bold**}, \verb{*italic*}, and \verb{_underlined_}. \cr
References to any bookmark can be inserted using the syntax \verb{@ref(bookmark)} and newlines can be inserted using the token \verb{<br>}.
}
\section{Markdown support}{

In all \code{crosstable} helpers for \code{officer}, you can use the following Markdown syntax to format your text:
\itemize{
\item \emph{bold}: \code{"**text in bold**"}
\item *italics: \code{"*text in italics*"}
\item \emph{subscript}: \code{"Text in ~subscript~"}
\item \emph{superscript}: \code{"Text in ^superscript^"}
\item \emph{newline}: \verb{Before <br> After}
\item \emph{color}: \code{"<color:red>red text</color>"}
\item \emph{shade}: \code{"<shade:yellow>yellow text</shade>"} (background color)
\item \emph{font family}: \code{"<ff:symbol>symbol</ff>"} (
}

Note that the font name depends on your system language. For instant, in French, it would be \code{Symbol} with an uppercase first letter.

See the last example of \code{\link[=body_add_normal]{body_add_normal()}} for a practical case.
}

\examples{
library(officer)
library(crosstable)

info_rows = c("Also, table iris has {nrow(iris)} rows.",
              "And table mtcars has {nrow(mtcars)} rows.")
doc = read_docx()  \%>\%
    body_add_normal("Table iris has", ncol(iris), "columns.", .sep=" ") \%>\% #paste style
    body_add_normal("However, table mtcars has {ncol(mtcars)} columns") \%>\% #glue style
    body_add_normal(info_rows)                                          \%>\% #vector style
    body_add_normal("")
doc = doc \%>\%
    body_add_normal("You can write text in *italic1*, _underlined1_, **bold1**, and `code`,
                    and you can also add * **references** *, for instance a ref to Table
                    @ref(my_table). Multiple spaces are ignored (squished) so that you
                    can enter multiline text.") \%>\%
    body_add_normal() \%>\%
    body_add_normal("Here I should use `body_add_crosstable()` to add a table before the
                     legend.") \%>\%
    body_add_table_legend("My pretty table", bookmark="my_table")
write_and_open(doc)

#Markdown support
read_docx() \%>\%
  body_add_normal("This is **bold and *italic* (see Table @ref(my_bkm)). ** <br> This is
                   **bold `console \\\\*CODE\\\\*` and *bold _and_ italic* **") \%>\%
  body_add_normal("This is <color:red>red **bold** text</color>, this is ~subscript *italic*~,
                   and this is ^superscript with <shade:yellow>yellow</shade>^") \%>\%
  body_add_normal("This is <ff:Alibi>a fancy font</ff> and this `is code`!!") \%>\%
              #you might need to change "Alibi" to "alibi" here
  body_add_normal() \%>\%
  body_add_table_legend("Some table legend", bookmark="my_bkm") \%>\%
  write_and_open()
}
\author{
Dan Chaltiel
}
