% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runtest.R
\name{runtest}
\alias{runtest}
\alias{runtest.default}
\title{Run a classification or regression test}
\usage{
runtest(test, ...)

\method{runtest}{default}(test, ...)
}
\arguments{
\item{test}{An object of class 'classification' or 'regression'}

\item{...}{Extra arguments to runtest}
}
\description{
Run a classification or regression test
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: The default test run subsequently calls \code{\link{prepare}}, \code{\link{train_model}}, \code{\link{make_predictions}},  \code{\link{evaluate}}
}}
\examples{
data(iris)
# A classification test
test <- createtest(data = iris, 
                  dependent = "Species",
                  problem = "classification",
                  method = "randomForest",
                  name = "An example classification test",
                  train_index = sample(150, 100)
)
\dontrun{
# Run the test
runtest(test)
}
}

