% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge-datasets.R
\name{extendDataset}
\alias{extendDataset}
\alias{merge.CrunchDataset}
\title{Add columns from one dataset to another, joining on a key}
\usage{
extendDataset(x, y, by.x, by.y, all = FALSE, all.x = TRUE, all.y = FALSE,
  ...)

\method{merge}{CrunchDataset}(x, y, by.x, by.y, all = FALSE, all.x = TRUE,
  all.y = FALSE, ...)
}
\arguments{
\item{x}{CrunchDataset to add data to}

\item{y}{CrunchDataset to copy data from. May be filtered by rows and/or
columns.}

\item{by.x}{CrunchVariable in \code{x} on which to join. Must have all
unique, non-missing values.}

\item{by.y}{CrunchVariable in \code{y} on which to join. Must have all
unique, non-missing values.}

\item{all}{logical: should all rows in x and y be kept, i.e. a "full outer"
join? Only \code{FALSE} is currently supported.}

\item{all.x}{logical: should all rows in x be kept, i.e. a "left outer"
join? Only \code{TRUE} is currently supported.}

\item{all.y}{logical: should all rows in y be kept, i.e. a "right outer"
join? Only \code{FALSE} is currently supported.}

\item{...}{additional arguments, ignored}
}
\value{
\code{x} extended by the columns of \code{y}, matched on the "by"
variables.
}
\description{
As \code{\link[base]{merge}} does for \code{data.frame}s, this function
takes two datasets, matches rows based on a specified key variable, and
adds columns from one to the other.
}

