% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable-definition.R
\name{VariableDefinition}
\alias{VariableDefinition}
\alias{VarDef}
\title{Construct a variable definition with (optional) additional metadata}
\usage{
VariableDefinition(data, ...)

VarDef(data, ...)
}
\arguments{
\item{data}{an R vector of data to convert to the Crunch payload format.
See code{\link{toVariable}} for how R types are converted. If \code{data}
is not supplied, you may instead supply \code{values}, which will not be
converted in any way, nor will extra type information be supplied. Only
send \code{values} if you know what you're doing. You may also omit both
\code{data} and \code{values} to create an empty variable on the server
(all values will be system missing "No Data").}

\item{...}{additional metadata attributes to send.}
}
\value{
a \code{VariableDefinition} object, ready to POST to Crunch.
}
\description{
Construct a variable definition with (optional) additional metadata
}
\examples{
VariableDefinition(rnorm(5), name="Some numbers",
    description="Generated pseudorandomly from the normal distribution")
VarDef(name="Integers", values=1:5, type="numeric",
    description="When creating variable definitions with 'values', you must
    specify 'type', and categorical variables will require 'categories'.")
}
\seealso{
\code{\link{toVariable}}
}
