% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new-dataset.R
\name{prepareDataForCrunch}
\alias{prepareDataForCrunch}
\title{Translate a data.frame to Crunch format}
\usage{
prepareDataForCrunch(data, ...)
}
\arguments{
\item{data}{A data.frame or other rectangular R object}

\item{...}{additional arguments passed to \code{ \link{createDataset}}.
"name" will be required by the Crunch server but is not required by this
function.}
}
\value{
A data.frame that is a transformation of \code{data} suitable for
uploading to Crunch, also containing a "metadata" attribute that is
the associated Crunch metadata.
}
\description{
This is called within \code{newDataset(ByCsv)} to extract the Crunch metadata
from the data and to transform the data to match the extracted metadata. You
can call this directly in order to tailor the data import flow more finely.
}
\seealso{
createWithPreparedData writePreparedData
}
