% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-data-frame.R
\name{merge.CrunchDataFrame}
\alias{merge.CrunchDataFrame}
\title{Merge a CrunchDataFrame}
\usage{
\method{merge}{CrunchDataFrame}(x, y, by = intersect(names(x), names(y)),
  by.x = by, by.y = by, sort = c("x", "y"), ...)
}
\arguments{
\item{x}{a CrunchDataFrame}

\item{y}{a standard data.frame}

\item{by}{name of the variable to match in both data sources (default: the intersection of the names of x and y)}

\item{by.x}{name of the variable to match in x}

\item{by.y}{name of the variable to match in y}

\item{sort}{character, either "x" or "y" (default: "x"). Which of the inputs should be used for the output order. Unlike merge.data.frame, merge.CrunchDataFrame will not re-sort the order of the output. It will use the order of either \code{x} or \code{y}.}

\item{...}{ignored}
}
\value{
a CrunchDataFrame with columns from both \code{x} and \code{y}
}
\description{
\code{merge}ing a CrunchDataFrame with a local dataframe is useful in situations
where you have new information in your local R session that you want to
connect with Crunch data. For example, for making
plots with Crunch and non-Crunch data. It produces a hybrid CrunchDataFrame
that has the local data attached to it, but like normal CrunchDataFrames
it is still judicious about downloading data from the server only when it
is needed.
}
\details{
Merging a CrunchDataFrame with a local dataframe does not allow specifying
all rows from both sources. Instead, the resulting CrunchDataFrame will
include all of the rows in whichever source is used for sorting (x or y). So
if you specify \code{sort="x"} (the default) all rows of x will be present but
rows in y that do not match with rows in x will not be present.

Merging a CrunchDataFrame with a local dataframe is experiemental and might
result in unexpected results. One known issue is that using \code{merge} on a
CrunchDataFrame will change the both the CrunchDataFrame used as input as
well as create a new CrunchDataFrame.
}
