% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shoji-catalog.R
\docType{methods}
\name{setNames}
\alias{setNames}
\alias{setNames,ShojiCatalog-method}
\title{Change the name of the entities in a catalog}
\usage{
setNames(object, nm)

\S4method{setNames}{ShojiCatalog}(object, nm)
}
\arguments{
\item{object}{A catalog object, such as \code{VariableFolder}}

\item{nm}{A character vector of new names of the same length as the number
of entities in the index}
}
\value{
\code{object}, with the names of its children duly changed
}
\description{
This is an alternative to assigning \code{names(catalog) <- something}, suitable
for inclusion in a pipeline.
}
\examples{
\dontrun{
ds <- ds \%>\%
    cd("Demographics") \%>\%
    setNames(c("Gender (4 category)", "Birth year", "Race (5 category)"))
}

}
\seealso{
\code{\link[=cd]{cd()}} and \code{\link[=mv]{mv()}}
}
