% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-dataset.R
\name{shinyDataset}
\alias{shinyDataset}
\title{Load a dataset for a Shiny session}
\usage{
shinyDataset(...)
}
\arguments{
\item{...}{Arguments passed to `loadDataset`}
}
\value{
A Shiny `reactive` object.
}
\description{
This function wraps [crunch::loadDataset()] in a
[shiny::reactive()] object for use in a Shiny app. It also ensures
that the current user is authenticated with Crunch before proceeding.
}
\examples{
\dontrun{
shinyServer(function(input, output, session) {
    ds <- shinyDataset("Your dataset name")

    freqs <- reactive({
        fmla <- as.formula(paste("~", input$varname))
        crtabs(fmla, data=ds())
    })
})
}
}
