/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;

public class CentroidLine {
    private Coordinate centSum = new Coordinate();
    private double totalLength = 0.0;

    public void add(Geometry geom) {
        if (geom instanceof LineString) {
            this.add(geom.getCoordinates());
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                this.add(gc.getGeometryN(i));
            }
        }
    }

    public Coordinate getCentroid() {
        Coordinate cent = new Coordinate();
        cent.x = this.centSum.x / this.totalLength;
        cent.y = this.centSum.y / this.totalLength;
        return cent;
    }

    public void add(Coordinate[] pts) {
        for (int i = 0; i < pts.length - 1; ++i) {
            double segmentLen = pts[i].distance(pts[i + 1]);
            this.totalLength += segmentLen;
            double midx = (pts[i].x + pts[i + 1].x) / 2.0;
            this.centSum.x += segmentLen * midx;
            double midy = (pts[i].y + pts[i + 1].y) / 2.0;
            this.centSum.y += segmentLen * midy;
        }
    }
}

