/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.geom.precision;

public class NumberPrecisionReducer {
    private double scaleFactor = 0.0;
    private boolean multiplyByScaleFactor = true;

    public static double scaleFactorForDecimalPlaces(int decimalPlaces) {
        int power = Math.abs(decimalPlaces);
        int sign = decimalPlaces >= 0 ? 1 : -1;
        double scaleFactor = 1.0;
        for (int i = 1; i <= power; ++i) {
            scaleFactor *= 10.0;
        }
        return scaleFactor * (double)sign;
    }

    public NumberPrecisionReducer() {
    }

    public NumberPrecisionReducer(double scaleFactor) {
        this.setScaleFactor(scaleFactor);
    }

    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = Math.abs(scaleFactor);
        this.multiplyByScaleFactor = scaleFactor >= 0.0;
    }

    public double reducePrecision(double d) {
        if (this.scaleFactor == 0.0) {
            return d;
        }
        if (this.multiplyByScaleFactor) {
            double scaled = d * this.scaleFactor;
            return Math.floor(scaled + 0.5) / this.scaleFactor;
        }
        double scaled = d / this.scaleFactor;
        return Math.floor(scaled + 0.5) * this.scaleFactor;
    }
}

