% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symm_fit_cor_fulllik.R
\name{symm_fit_cor_EM_fulllik}
\alias{symm_fit_cor_EM_fulllik}
\title{symm_fit_cor_fulllik.R}
\usage{
symm_fit_cor_EM_fulllik(
  testStats,
  corMat,
  initMuList,
  initPiList,
  eps = 10^(-5),
  checkpoint = TRUE
)
}
\arguments{
\item{testStats}{J*K matrix of test statistics where J is the number of sets and K is number of elements in each set.}

\item{corMat}{K*K matrix that describes the correlation structure of each 2 by 2 block.}

\item{initMuList}{List of 2^K elements where each element is a matrix with K rows and number of columns equal to the number of possible mean vectors for that binary group.}

\item{initPiList}{List of 2^K elements where each element is a vector with number of elements equal to the number of possible mean vectors for that binary group.}

\item{eps}{Scalar, stop the EM algorithm when L2 norm of difference in parameters is less than this value.}

\item{checkpoint}{Boolean, set to TRUE to print iterations of EM.}
}
\value{
A list with the elements:
\item{muInfo}{List with same dimensions as initMuList, holds the final mean parameters.}
\item{piInfo}{List with same dimensions as initPiList, holds the final probability parameters.}
\item{iter}{Number of iterations run in EM algorithm.}
\item{lfdrResults}{J*1 vector of all lfdr statistics.}
}
\description{
Full likelihood, block correlation, blocks of size 2
}
\examples{
set.seed(0)
testStats <- cbind(rnorm(10^4), rnorm(10^4))
testStats[1:100, 1] <- rnorm(100, mean=3)
testStats[101:200, 1] <- rnorm(100, mean=5)
testStats[201:300, 2] <- rnorm(100, mean=4)
testStats[301:400, 1:2] <- rnorm(200, mean=7)
initMuList <- list(matrix(data=0, nrow=2, ncol=1), matrix(data=c(0, 3), nrow=2, ncol=1),
matrix(data=c(3, 0), nrow=2, ncol=1), matrix(data=c(6, 6), nrow=2, ncol=1))
initPiList <- list(c(0.9), c(0.04),c(0.04), c(0.02))
results <- symm_fit_cor_EM_fulllik(testStats = testStats, corMat=diag(c(1,1)),
initMuList = initMuList, initPiList = initPiList)

}
