% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cso_get_data.R
\name{cso_get_data}
\alias{cso_get_data}
\title{Return a CSO table as a data frame}
\usage{
cso_get_data(
  table_code,
  pivot_format = "wide",
  wide_format = lifecycle::deprecated(),
  include_ids = FALSE,
  id_list = NULL,
  use_factors = TRUE,
  use_dates = FALSE,
  cache = TRUE,
  flush_cache = TRUE
)
}
\arguments{
\item{table_code}{string. If the table_code is a filename or a path to a
file, e.g. "QNQ22.json", it is imported from that file. Otherwise if it is
only a table code e.g. "QNQ22", the file is downloaded from data.cso and
checked to see if it is a valid table.}

\item{pivot_format}{string, one of "wide", "very_wide", "tall" or "tidy. If "wide"
(default) the table is returned in wide (human readable) format, with
statistic as a column (if it exists). If "very_wide" the table is returned
wide format and spreads the statistic column to rows. If "tall" the table is
returned in tall (statistic and value) format.If "tidy" will be returned in a tidy-like format.}

\item{wide_format}{string. Deprecated argument as of 1.4.0. Please use pivot_format instead.}

\item{include_ids}{logical. The JSON-stat format stores variables as ids
i.e. IE11 and labels i.e. Border. While the label is generally preferred,
sometimes it is useful to have the ids to match on. If \code{include_ids}
is TRUE (default) then ids are retrieved and appended to the table to the
right of the original column with the name <columnName>.id.}

\item{id_list}{either NULL (default) or a character vector of columns that
should have ids appended if include_ids is TRUE.
if NULL then every column that is not included in the vector
\code{remove_id} will be used.}

\item{use_factors}{logical. If TRUE (default) factors will be used in
strings.}

\item{use_dates}{logical. If True dates will be returned as date-time competent.
Default is FALSE.}

\item{cache}{logical. if TRUE (default) csodata will cache the result using
R.cache. The raw data downloaded from the data.csi.ie is cached, which means
that calling \code{cso_get_data} with the same table_code but different
parameterswill result in cached data being used.}

\item{flush_cache}{logical. If TRUE (default) the cache will be checked for 
old, unused files. Any files which have not been accessed in the last month
 will be deleted.}
}
\description{
Returns a CSO table from the CSO PxStat Application Programming Interface
(API) as a data frame, with the option to give it in wide format (default)
very wide or long format.
}
\details{
The data is pulled from the ResponseInstance service on the CSO API in
JSON-Stat format, using the GET method from the httr package.
}
\examples{
\dontrun{
tbl1 <- cso_get_data("QNQ22")
tbl2 <- cso_get_data("QLF07.json")
}
}
