% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_map.R
\name{generate_map}
\alias{generate_map}
\title{Generate map visualizations (choropleths) of CSPP data}
\arguments{
\item{cspp_data}{Dataframe generated by \code{get_cspp_data} which must
include the variable \code{state}. If there are multiple years of data per
state, by default the most recent year is used in creating the map unless
\code{average_years} is set to \code{TRUE}. Default is NULL and returns the
most recent year's \code{poptotal} data as an example map.}

\item{var_name}{Specify the variable from the dataset passed to
\code{cspp_data} to plot on the map. If left blank, the first variable that
is not "year", "st", "state", "state_fips", or "state_icspr" is used.
Default is NULL.}

\item{average_years}{Default is \code{FALSE}. If \code{TRUE}, averages over
all of the years per state in the dataframe to produce a value to plot on
the map. If the type of the variable in \code{var_name} is not numeric,
will reset this parameter to FALSE.}

\item{drop_NA_states}{Choose whether to drop states at the map generating
  stage which have NA values. Default is \code{FALSE} and states with missing
  data will be filled grey. If set to \code{TRUE}, states will have no fill
  in the plot.

  If you're passing a dataframe subset to certain states, set this to TRUE.}

\item{poly_args}{Default is \code{list(color = "#666666", size = .5)}.
Changes the aesthetics of how the states look when plotted. The \code{fill}
of each state can be manually changed through ggplot's \code{scale_fill_}
(see examples). See \code{\link[ggplot2]{geom_polygon}} for other options
to pass to this argument.}
}
\value{
Returns a \code{ggplot} object. See examples for how to work with
  this object.
}
\description{
\code{generate_map} takes CSPP data from \code{\link{get_cspp_data}} and plots the
values of numeric variables on the map of the U.S. It can also plot
individual states or sets of states.
}
\details{
Note: due to complications with plotting Alaska and Hawaii, this package
currently does not support plotting these two states.

This function is general in the sense that it will produce a ggplot-style map
for any dataframe passed to it with the proper formatting. Any dataframe that
has at least three columns, with the first two a numeric `year` column and a
state name as a string, and the final column the value to be plotted, will
work with this function.
}
\examples{

## default map with total population
generate_map()

## pass specific variables
# returns average over all non NA years in the data
generate_map(get_cspp_data(var_category = "demographics"),
             var_name = "pctpopover65")

## add additional ggplot options
generate_map(get_cspp_data(var_category = "demographics"),
             var_name = "pctpopover65",
             poly_args = list(color = "black"),
             drop_NA_states = FALSE) +
 ggplot2::scale_fill_gradient(low = "white", high = "red") +
 ggplot2::theme(legend.position = "none") +
 ggplot2::ggtitle("\% Population Over 65")

## plot specific states
# drop_NA_states set to TRUE plots only those states
library(dplyr)
generate_map(get_cspp_data(var_category = "demographics") \%>\%
               dplyr::filter(st \%in\% c("NC", "VA", "SC")),
             var_name = "pctpopover65",
             poly_args = list(color = "black"),
             drop_NA_states = TRUE) +
 ggplot2::scale_fill_gradient(low = "white", high = "red") +
 ggplot2::theme(legend.position = "none") +
 ggplot2::ggtitle("\% Population Over 65")

## pass specific variables and years
# returns average over set of years provided
library(dplyr)
generate_map(get_cspp_data(var_category = "demographics") \%>\%
 dplyr::filter(year \%in\% seq(2001, 2010)))

# returns average over set of years provided
library(dplyr)
generate_map(get_cspp_data(var_category = "demographics") \%>\%
 dplyr::filter(year \%in\% seq(2001, 2010)))

}
\seealso{
\code{\link{get_cspp_data}}, \code{\link{get_cites}}, \code{\link{get_var_info}}
}
