% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.R
\name{expand_wildcards}
\alias{expand_wildcards}
\title{Expand c-squares with wildcards to all matching c-squares}
\usage{
expand_wildcards(x, csquares, ...)
}
\arguments{
\item{x}{A \code{character} string containing csquares codes with
wildcards (asterisk character); or a \code{data.frame} that contains
a column with csquares codes with wildcards}

\item{csquares}{When \code{x} is \code{data.frame} this argument should
specify the column name that contains the csquares codes with wildcards.}

\item{...}{ignored}
}
\value{
Returns a \code{csquares} object with full notation
}
\description{
The asterisk (*) can be used as a wildcard, for a compact
notation of csquares. \code{expand_wildcards} will replace all
wild cards with valid combinations of values and expands
the compact notation to an explicit notation without
wildcards.
Check out \code{vignette("wildcards")} for more details.
}
\examples{
expand_wildcards("1000:*")
expand_wildcards("1000:***")
expand_wildcards("1000:1**")
expand_wildcards("1000:***:*")
expand_wildcards(c("1000:*", "1000:***", "1000:1**", "1000:***:*"))

expand_wildcards(data.frame(csq = "1000:*", foo = "bar"), csquares = "csq")
}
\author{
Pepijn de Vries
}
