% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/csrplus.R
\name{pielou}
\alias{pielou}
\title{Nearest Neighbor Test Statistic:  Pielou}
\source{
Cressie, Noel. "Chapter 8: Spatial Point Patterns." Statistics for Spatial Data. Revised ed. New York: John Wiley and Sons, 1993. N. pag. Print.

Gatrell, Anthony C. "Chapter 3: Introductory Methods for Point Patterns." Interactive Spatial Data Analysis. By Trevor C. Bailey. N.p.: Routledge, 1995. N. pag. Print.
}
\usage{
pielou(xcoord, ycoord, points, boundaryx, boundaryy, lambda)
}
\arguments{
\item{xcoord}{a vector containing the x-coordinates of the observed point process}

\item{ycoord}{a vector containing the y-coordinates of the observed point process}

\item{points}{integer for the number of events for which to calculate point-to-event distances}

\item{boundaryx}{a vector containing the x-coordinates of the boundary}

\item{boundaryy}{a vector containing the y-coordinates of the boundary}

\item{lambda}{integer for the estimated intensity of the point process (likely the area of the region of observation divided by the number of events)}
}
\value{
pstat a integer for the calcualted test statistic
}
\description{
Calculates the nearest neighbor test statistic for a spatial point process based on that proposed by Pielou (1959).
The test statistic is based on sample point to event distances.  It is equal to sum from i=1 to n of [(pi*lambda*(x_i)^2)/(n)], where x_i is equal to the point-to-event distance, lambda is equal to the intensity of the point process, and n is equal to the number of sample point-to-event distances.  The test statistic follows a normal distribution with mean 1 and variance 1/n.
}
\details{
The function begins by proposing a sample point within the region of observation.  It then calculates and stores the distance from this point to the nearest event.
The process is repeated for the number of sample points specified by the user.
Based on the stored distances, and the input for lambda, the test statistic of sum from i=1 to n of [(pi*lambda*(x_i)^2)/(n)] is calculated.

The test statistic serves as an alternative to that proposed by Clark and Evans (1954).  Instead of comparing event-to-event distances, the function makes use of sample point-to-event distances.
Knowing that the test statistic follows a normal distribution of mean 1 and variance 1/n, it can be used in the calculation of a z-statistic to evaluate the hypothesis of complete spatial randomness.

In order for the selection of sample points to not bias the results, it is suggested that the function be run multiple times to obtain an average test statistic .

The test statistic should be used with caution as the function does not account for edge effects.
As points along the border will have larger nearest neighbor distances, the normal approximation of the test statistic will underestimate the mean distance.
When looking at event-to-point distances, it is expected that distances will be larger in a clustered process than in a process that exhibits complete spatial randomness.
While the event-to-point distance will be small if the random event happens to be located in a cluster, there is a high probability that the sample point will be located in a sparsely populated region and therefore have a large nearest neighbor distance.
By underestimating the mean distance, there is consequently more evidence to reject the null hypothesis of complete spatial randomness.

While the test statistic can provide a good first assessment of the null hypothesis of complete spatial randomness, it should not be relied upon as a definitive measure.
More accurate conclusions can likely be drawn by comparing the observed process to simulations of a random process generated over the specific region of observation.
}
\examples{
# To load data corresponding to the location of earthquakes in California:
data(quake)

# To load data corresponding to the boundary:
data(boundary)

# To compute the one hundred values of the test statistic:
p <- mat.or.vec(100,1)
for (i in 1:100) {
   p[i] <- pielou(quake[,3], quake[,2], 30, boundary[,1], boundary[,2], 7.177) }
# To compute the average test statistic:
pavg <- mean(p)
# To calculate a z-statistic to evalute the null hypothesis of complete spatial randomness:
z <- (pavg-1)/sqrt(1/30)
}

