% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctbi.outlier.R
\name{ctbi.outlier}
\alias{ctbi.outlier}
\title{ctbi.outlier}
\usage{
ctbi.outlier(y, coeff.outlier = "auto")
}
\arguments{
\item{y}{univariate data (numeric vector)}

\item{coeff.outlier}{One of coeff.outlier = 'auto' (default value), coeff.outlier = 'gaussian', coeff.outlier = c(A,B,C) or coeff.outlier = NA. If coeff.outlier = 'auto', C = 36 and the coefficients A and B are calculated on m.star, a predictor of the kurtosis excess. If coeff.outlier = 'gaussian', coeff.outlier = c(0.08,2,36), adapted to the Gaussian distribution. If coeff.outlier = NA, no outliers are flagged.}
}
\value{
A list that contains:

xy, a two columns data frame that contains the clean data (first column) and the outliers (second column).

summary.outlier = c(A,B,C,m.star,n,lower.outlier.threshold,upper.outlier.threshold)
}
\description{
Flag outliers in univariate datasets with the Logbox method, which replaces the original constant 1.5 of the Boxplot rule with Alog(n)+B+C/n, with n being the sample size (n > 8). For 2 < n < 9, the lower/upper outlier threshold are defined as median(y) +/- 12.5MAD with MAD the median absolute deviation. Details are given in Ritter, F.: Technical note: A procedure to clean, decompose and aggregate time series, Hydrol. Earth Syst. Sci. Discuss., in review, 2022. Temporary DOI linked to the latest version of the manuscript until the review is finished: <https://doi.org/10.31223/X5107C>.
}
\examples{
x <- runif(30)
x[c(5,10,20)] <- c(-10,15,30)
example1 <- ctbi.outlier(x)
}
