% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrFindActiveSubstanceSynonyms.R
\name{ctrFindActiveSubstanceSynonyms}
\alias{ctrFindActiveSubstanceSynonyms}
\title{Find synonyms of an active substance}
\usage{
ctrFindActiveSubstanceSynonyms(activesubstance = "", verbose = FALSE)
}
\arguments{
\item{activesubstance}{An active substance, in an atomic character vector}

\item{verbose}{Print number of studies found in CTGOV2 for `activesubstance`}
}
\value{
A character vector of the active substance (input parameter) and
 synonyms, or NULL if active substance was not found and may be invalid
}
\description{
An active substance can be identified by a recommended international
nonproprietary name (INN), a trade or product name, or a company code(s).
To find likely synonyms, the function retrieves from CTGOV2 the field
protocolSection.armsInterventionsModule.interventions.otherNames.
Note this is not free of error and should be checked manually.
}
\examples{
\dontrun{

ctrFindActiveSubstanceSynonyms(activesubstance = "imatinib")
#  [1] "imatinib"                    "Carcemia"                    "Cemivil"
#  [4] "CGP 57148"                   "CGP-57148B"                  "CGP57148B"
#  [7] "Gleevac"                     "gleevec"                     "Gleevec (Imatinib Mesylate)"
# [10] "Glevec"                      "glivec"                      "Imatinib"
# [13] "imatinib mesylate"           "Imatinib-AFT"                "IND # 55666"
# [16] "NSC #716051"                 "NSC-716051"                  "QTI571"
# [19] "ST1571"                      "STI 571"                     "STI-571"
# [22] "STI571"                      "tyrosine kinase inhibitors"

}
}
