% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chebycheff_dispersion.R
\encoding{UTF-8}
\name{chebycheff_dispersion}
\alias{chebycheff_dispersion}
\title{Computes the Chebycheff dispersion of a categorical time series}
\usage{
chebycheff_dispersion(series, categories)
}
\arguments{
\item{series}{A CTS.}

\item{categories}{A vector of type factor containing the corresponding
categories.}
}
\value{
The value of the Chebycheff dispersion.
}
\description{
\code{chebycheff_dispersion} returns the value of the Chebycheff dispersion for
a categorical time series
}
\details{
Given a CTS of length \eqn{T} with range \eqn{\mathcal{V}=\{1, 2, \ldots, r\}},
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function computes the
estimated Chebycheff dispersion, \eqn{\widehat{c}=\frac{r}{r-1}(1-\max_i\widehat{p}_i)},
where \eqn{\widehat{p}_i} is the natural estimate of the marginal probability of the \eqn{i}th
category, \eqn{i=1, \ldots, r}.
}
\examples{
cd <- chebycheff_dispersion(series = GeneticSequences$data[[1]],
categories = factor(c('a', 'c', 'g', 't'))) # Computing the Chebycheff dispersion
# for the first series in dataset GeneticSequences
}
\references{
{

  \insertRef{weiss2008measuring}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
