% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cramer.R
\encoding{UTF-8}
\name{plot_cramer}
\alias{plot_cramer}
\title{Constructs a serial dependence plot based on Cramer's vi}
\usage{
plot_cramer(
  series,
  categories,
  max_lag = 10,
  alpha = 0.05,
  plot = TRUE,
  title = "Serial dependence plot",
  bar_width = 0.12,
  ...
)
}
\arguments{
\item{series}{A CTS.}

\item{categories}{A vector of type factor containing the corresponding
categories.}

\item{max_lag}{The maximum lag represented in the plot (default is 10).}

\item{alpha}{The significance level for the corresponding hypothesis test (default is 0.05).}

\item{plot}{Logical. If \code{plot = TRUE} (default), returns the serial dependence
plot. Otherwise, returns a list with the values of Cramer's vi, the critical
value and the corresponding p-values.}

\item{title}{The title of the graph.}

\item{bar_width}{The width of the corresponding bars.}

\item{...}{Additional parameters for the function.}
}
\value{
If \code{plot = TRUE} (default), returns the serial dependence plot based on Cramer's vi. Otherwise, the function
returns a list with the values of Cramer's vi, the critical
value and the corresponding p-values.
}
\description{
\code{plot_cramer} constructs a serial dependence plot of a categorical
time series based on Cramer's vi
}
\details{
Constructs a serial dependence plot based on Cramer's vi, \eqn{\widehat{v}(l)},
for several lags. A dashed lined is incorporated indicating the critical value
of the test based on the following asymptotic approximation (under the i.i.d. assumption):
\deqn{T(r-1)\widehat{v}(l)^2 \sim\chi^2_{(r-1)^2},} where \eqn{T} is the series length
and \eqn{r} is the number of categories in the time series.
}
\examples{
plot_cv <- plot_cramer(series = SyntheticData1$data[[1]],
categories = factor(c(1, 2, 3)), max_lag = 3) # Representing
# the serial dependence plot
list_cv <- plot_cramer(series = SyntheticData1$data[[1]],
categories = factor(c(1, 2, 3)), max_lag = 3, plot = FALSE) # Obtaining
# the values of Cramer's vi, the critical value and the p-values
}
\references{
{

  \insertRef{weiss2013serial}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
