% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_index.R
\name{get_fop}
\alias{get_fop}
\title{Fraction of optimal codons (Fop)}
\usage{
get_fop(seqs, codon_table = get_codon_table())
}
\arguments{
\item{seqs}{CDS sequences of all protein-coding genes. One for each gene.}

\item{codon_table}{a table of genetic code derived from `get_codon_table` or `create_codon_table`.}
}
\value{
a named vector of fop values.
}
\description{
\code{get_fop} calculates the fraction of optimal codons (Fop) of each CDS.
}
\examples{
# estimate Fop of yeast genes
fop <- get_fop(yeast_cds)
head(fop)
hist(fop)

}
\references{
Ikemura T. 1981. Correlation between the abundance of Escherichia coli transfer RNAs and the occurrence of the respective codons in its protein genes: a proposal for a synonymous codon choice that is optimal for the E. coli translational system. J Mol Biol 151:389-409.
}
