% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_index.R
\name{get_gc3s}
\alias{get_gc3s}
\title{GC contents at synonymous 3rd codon positions}
\usage{
get_gc3s(cf, codon_table = get_codon_table())
}
\arguments{
\item{cf}{matrix of codon frequencies as calculated by `count_codons()`.}

\item{codon_table}{a table of genetic code derived from `get_codon_table` or `create_codon_table`.}
}
\value{
a named vector of GC3s values.
}
\description{
Calculate GC content at synonymous 3rd codon positions.
}
\examples{
# estimate GC3s of yeast genes
cf_all <- count_codons(yeast_cds)
gc3s <- get_gc3s(cf_all)
head(gc3s)
hist(gc3s)

}
\references{
Peden JF. 2000. Analysis of codon usage.
}
