% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codon_weight.R
\name{est_csc}
\alias{est_csc}
\title{Estimate Codon Stabilization Coefficient}
\usage{
est_csc(
  seqs,
  half_life,
  codon_table = get_codon_table(),
  cor_method = "pearson"
)
}
\arguments{
\item{seqs}{CDS sequences of all protein-coding genes. One for each gene.}

\item{half_life}{data.frame of mRNA half life (gene_id & half_life are column names).}

\item{codon_table}{a table of genetic code derived from `get_codon_table` or `create_codon_table`.}

\item{cor_method}{method name passed to `cor.test` used for calculating correlation coefficients.}
}
\value{
data.table of optimal codons.
}
\description{
\code{get_csc} calculate codon occurrence to mRNA stability correlation coefficients (Default to Pearson's).
}
\examples{
# estimate yeast mRNA CSC
est_csc(yeast_cds, yeast_half_life)

}
\references{
Presnyak V, Alhusaini N, Chen YH, Martin S, Morris N, Kline N, Olson S, Weinberg D, Baker KE, Graveley BR, et al. 2015. Codon optimality is a major determinant of mRNA stability. Cell 160:1111-1124.
}
