% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cubeView.R
\name{cubeview}
\alias{cubeview}
\alias{cubeview.character}
\alias{cubeview.stars}
\alias{cubeview.Raster}
\alias{cubeView}
\title{View a RasterStack or RasterBrick as 3-dimensional data cube.}
\usage{
cubeview(x, ...)

\method{cubeview}{character}(
  x,
  at,
  col.regions = viridisLite::inferno,
  na.color = "#BEBEBE",
  legend = TRUE,
  options = cubeOptions(),
  legend.options = legendOptions(),
  ...
)

\method{cubeview}{stars}(
  x,
  at,
  col.regions = viridisLite::inferno,
  na.color = "#BEBEBE",
  legend = TRUE,
  options = cubeOptions(),
  legend.options = legendOptions(),
  ...
)

\method{cubeview}{Raster}(
  x,
  at,
  col.regions = viridisLite::inferno,
  na.color = "#BEBEBE",
  legend = TRUE,
  options = cubeOptions(),
  legend.options = legendOptions(),
  ...
)

cubeView(x, ...)
}
\arguments{
\item{x}{a file name, stars object, RasterStack or RasterBrick}

\item{...}{additional arguments passed on to \link[stars]{read_stars}.}

\item{at}{the breakpoints used for the visualisation. See
\code{\link[lattice]{levelplot}} for details.}

\item{col.regions}{either a palette function or a vector of colors to be
used for palette generation.}

\item{na.color}{color for missing values.}

\item{legend}{logical. Whether to plot a legend.}

\item{options}{list of options (x_pos, y_pos, z_pos) for the cube.
See \link{cubeOptions} for details.}

\item{legend.options}{list of options (width & height in pixels) for the legend.
See \link{legendOptions} for details.}
}
\description{
Creates a 3D data cube view of a RasterStack/Brick.
Slices through each dimension (x/y/z) are mapped to the visible sides of the cube.
The cube can be freely rotated. Zooming and panning can be used to focus on
different areas of the cube.

See Details for information on how to control the location of the slices and all
other available keyborad and mouse guestures to control the cube.
}
\details{
The location of the slices can be controlled by keys: \cr
x-axis: LEFT / RIGHT arrow key \cr
y-axis: DOWN / UP arrow key \cr
z-axis: PAGE_DOWN / PAGE_UP key \cr

\emph{Other controls:} \cr
Press and hold left mouse-button to rotate the cube. \cr
Press and hold right mouse-button to move the cube. \cr
Spin mouse-wheel or press and hold middle mouse-button and
move mouse down/up to zoom the cube. \cr
Press space bar to show/hide slice position guides. \cr

\emph{Note:} \cr
In RStudio cubeView may show a blank viewer window. In this case open the view in
a web-browser (RStudio button at viewer: "show in new window").

\emph{Note:} \cr
Because of key focus issues key-press-events may not always
recognised within RStudio on Windows. In this case open the view in
a web-browser (RStudio button at viewer: "show in new window").
}
\examples{
if (interactive()) {
  library(raster)
  library(stars)

  ## directly from file
  kili_data <- system.file("extdata", "kiliNDVI.tif", package = "cubeview")
  cubeview(kili_data)

  ## stars object
  kili_strs = read_stars(kili_data)
  cubeview(kili_strs)

  ## rsater stack (also works with brick)
  kili_rstr <- stack(kili_data)
  cubeview(kili_rstr)

  ## use different color palette and set breaks
  clr <- viridisLite::viridis
  cubeview(kili_data, at = seq(-0.15, 0.95, 0.1), col.regions = clr)

  ## specify initial location of slices
  cubeview(kili_data, options = cubeOptions(x_pos = 21, y_pos = 45, z_pos = 22))
}

}
\author{
Stephan Woellauer and Tim Appelhans
}
