% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handle.R
\name{handle}
\alias{handle}
\alias{new_handle}
\alias{handle_setopt}
\alias{handle_setheaders}
\alias{handle_getheaders}
\alias{handle_getcustom}
\alias{handle_setform}
\alias{handle_reset}
\alias{handle_data}
\title{Create and configure a curl handle}
\usage{
new_handle(...)

handle_setopt(handle, ..., .list = list())

handle_setheaders(handle, ..., .list = list())

handle_getheaders(handle)

handle_getcustom(handle)

handle_setform(handle, ..., .list = list())

handle_reset(handle)

handle_data(handle)
}
\arguments{
\item{...}{named options / headers to be set in the handle.
To send a file, see \code{\link{form_file}}. To list all allowed options,
see \code{\link{curl_options}}}

\item{handle}{Handle to modify}

\item{.list}{A named list of options. This is useful if you've created
a list of options elsewhere, avoiding the use of \code{do.call()}.}
}
\value{
A handle object (external pointer to the underlying curl handle).
All functions modify the handle in place but also return the handle
so you can create a pipeline of operations.
}
\description{
Handles are the work horses of libcurl. A handle is used to configure a
request with custom options, headers and payload. Once the handle has been
set up, it can be passed to any of the download functions such as \code{\link{curl}}
,\code{\link{curl_download}} or \code{\link{curl_fetch_memory}}. The handle will maintain
state in between requests, including keep-alive connections, cookies and
settings.
}
\details{
Use \code{new_handle()} to create a new clean curl handle that can be
configured with custom options and headers. Note that \code{handle_setopt}
appends or overrides options in the handle, whereas \code{handle_setheaders}
replaces the entire set of headers with the new ones. The \code{handle_reset}
function resets only options/headers/forms in the handle. It does not affect
active connections, cookies or response data from previous requests. The safest
way to perform multiple independent requests is by using a separate handle for
each request. There is very little performance overhead in creating handles.
}
\examples{
h <- new_handle()
handle_setopt(h, customrequest = "PUT")
handle_setform(h, a = "1", b = "2")
r <- curl_fetch_memory("https://hb.cran.dev/put", h)
cat(rawToChar(r$content))

# Or use the list form
h <- new_handle()
handle_setopt(h, .list = list(customrequest = "PUT"))
handle_setform(h, .list = list(a = "1", b = "2"))
r <- curl_fetch_memory("https://hb.cran.dev/put", h)
cat(rawToChar(r$content))
}
\seealso{
Other handles: 
\code{\link{handle_cookies}()}
}
\concept{handles}
