% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oc_youden_kernel.R
\name{oc_youden_kernel}
\alias{oc_youden_kernel}
\title{Determine an optimal cutpoint maximizing the Youden-Index based on kernel smoothed densities}
\source{
Fluss, R., Faraggi, D., & Reiser, B. (2005). Estimation of the
Youden Index and its associated cutoff point. Biometrical Journal, 47(4), 458–472.

Matt Wand (2015). KernSmooth: Functions for Kernel Smoothing
Supporting Wand & Jones (1995). R package version 2.23-15.
https://CRAN.R-project.org/package=KernSmooth
}
\usage{
oc_youden_kernel(data, x, class, pos_class, neg_class, direction, ...)
}
\arguments{
\item{data}{A data frame or tibble in which the columns that are given in x
and class can be found.}

\item{x}{(character) The variable name to be used for classification,
e.g. predictions or test values.}

\item{class}{(character) The variable name indicating class membership.}

\item{pos_class}{The value of class that indicates the positive class.}

\item{neg_class}{The value of class that indicates the negative class.}

\item{direction}{(character) Use ">=" or "<=" to select whether an x value
>= or <= the cutoff predicts the positive class.}

\item{...}{To capture further arguments that are always passed to the method
function by cutpointr. The cutpointr function passes data, x, class,
metric_func, direction, pos_class and neg_class to the method function.}
}
\description{
Instead of searching for an optimal cutpoint to maximize (sensitivity +
specificity - 1) on the ROC curve, this function first smoothes the empirical
distributions of \code{x} per class. The smoothing is done using a binned kernel
density estimate. The bandwidth is automatically selected using the direct
plug-in method.
}
\details{
The functions for calculating the kernel density estimate and the bandwidth
are both from \pkg{KernSmooth} with default parameters, except for
the bandwidth selection, which uses the standard deviation as scale estimate.
}
\examples{
data(suicide)
if (require(KernSmooth)) {
  oc_youden_kernel(suicide, "dsi", "suicide", oc_metric = "Youden",
  pos_class = "yes", neg_class = "no", direction = ">=")
  ## Within cutpointr
  cutpointr(suicide, dsi, suicide, method = oc_youden_kernel)
}
}
\seealso{
Other method functions: \code{\link{maximize_boot_metric}},
  \code{\link{maximize_gam_metric}},
  \code{\link{maximize_loess_metric}},
  \code{\link{maximize_metric}},
  \code{\link{maximize_spline_metric}},
  \code{\link{oc_manual}}, \code{\link{oc_mean}},
  \code{\link{oc_median}}, \code{\link{oc_youden_normal}}
}
