% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{cvSummaryPlot}
\alias{cvSummaryPlot}
\title{Summary Plot}
\usage{
cvSummaryPlot(
  dat,
  estimator,
  dat_orig,
  stat,
  k,
  leading,
  plot_type = "summary",
  cv_details,
  has_hypers,
  multi_hypers,
  abs_v,
  switch_vars,
  min_max
)
}
\arguments{
\item{dat}{A named \code{list}.  Specifically, this is the standard output of
\code{cvCovEst}.}

\item{estimator}{A \code{character} vector specifying which class of
estimator to plot.}

\item{dat_orig}{The \code{numeric data.frame}, \code{matrix}, or similar
object originally passed to \code{cvCovEst}.}

\item{plot_type}{A \code{character} detailing the type of plot. Passed to
\code{\link{theme_cvCovEst}()}, defaults to \code{"risk"}}

\item{cv_details}{Character vector summarizing key arguments passed to
\code{\link{cvCovEst}()}.}

\item{has_hypers}{A \code{character} vector containing the names of current
estimators with hyperparameters.}

\item{multi_hypers}{A \code{character} vector containing the names of current
estimators with multiple hyperparameters.}

\item{abs_v}{A \code{logical} determining if the absolute value of the matrix
entries should be used for plotting the matrix heatmap.  Default is
\code{TRUE}.}

\item{switch_vars}{A \code{logical}. If \code{TRUE},
the hyperparameters used for the x-axis and factor variables are switched.
Only applies to estimators with more than one hyperparameter. Defaults to
\code{FALSE}.}

\item{min_max}{A \code{logical}. If \code{TRUE}, only the minimum and
maximum values of the factor hyperparameter will be used.  Only applies to
estimators with more than one hyperparameter. Defaults to \code{FALSE}.}
}
\value{
A collection of plots and summary statistics for the optimal
estimator selected by \code{cvCovEst}.
}
\description{
\code{cvSummaryPlot()} combines plots of the eigenvalues and the
covariance heatmap for the optimal estimator selected by
\code{\link{cvCovEst}()}, and also provides a table showing the best
estimator within each class.  A plot the risk of the optimal estimator's
class is also provided if applicable.
}
\keyword{internal}
