% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-stats.R
\name{mae}
\alias{mae}
\alias{nmae}
\alias{rmse}
\alias{nrmse}
\alias{smape}
\alias{sse}
\title{Error functions}
\usage{
mae(orig, pred)

nmae(orig, pred)

rmse(orig, pred)

nrmse(orig, pred)

smape(orig, pred)

sse(orig, pred)
}
\arguments{
\item{orig}{numeric vector of original data points}

\item{pred}{numeric vector of predicted data points}
}
\value{
numeric error term
}
\description{
Functions measuring the accuracy between original and predicted data. Can
be used as target functions for e.g. optimization routines which minimize the
error term.
}
\details{
The following error functions are available:
\itemize{
\item Mean Absolute Error (MAE)
\item Normalized Mean Absolute Error (NMAE)
\item Root Mean Square Error (RMSE)
\item Normalized Root Mean Square Error (NRMSE)
\item Symmetric Mean Absolute Percentage Error (SMAPE)
\item Sum of Squared Errors (SSE)
}
}
\examples{
# Mean Absolute Error
mae(1:5, 1:5+0.1)
# Sum of Squared Errors
sse(1:5, 1:5+0.1)
}
