% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_definitions.R
\name{select_definitions}
\alias{select_definitions}
\title{Select model definition columns}
\usage{
select_definitions(results, unnest_hparams = TRUE, additional_includes = NULL)
}
\arguments{
\item{results}{Results tibble. E.g. from
\code{\link[cvms:cross_validate]{cross_validate()}} or \code{\link[cvms:evaluate]{evaluate()}}.}

\item{unnest_hparams}{Whether to unnest the \code{HParams} column. (Logical)}

\item{additional_includes}{Names of additional columns to select. (Character)}
}
\value{
The model definition columns from the results tibble.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

 Select the columns that define the models, such as the formula terms
 and hyperparameters.

 If an expected column is not in the \code{results} tibble, it is simply ignored.
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
