% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cxr_pm_bootstrap.R
\name{cxr_pm_bootstrap}
\alias{cxr_pm_bootstrap}
\title{Standard error estimates for model parameters}
\usage{
cxr_pm_bootstrap(
  fitness_model,
  optimization_method,
  data,
  focal_column,
  covariates,
  init_par,
  lower_bounds,
  upper_bounds,
  fixed_parameters,
  bootstrap_samples
)
}
\arguments{
\item{fitness_model}{function returning a single value to minimize, given a set of parameters and a fitness metric}

\item{optimization_method}{numerical optimization method}

\item{data}{dataframe with observations in rows and two sets of columns:
\itemize{
\item fitness: fitness metric for the focal individual
\item neighbours: columns with user-defined names with number of neighbours for each group
}}

\item{focal_column}{optional integer value giving the position, or name, of the column
with neighbours from the same species as the focal one. This is necessary if "alpha_intra" is specified.}

\item{covariates}{optional matrix with observations in rows and covariates in columns. Each cell is the value of a covariate
in a given observation.}

\item{init_par}{1d vector of initial parameters}

\item{lower_bounds}{1d vector of lower bounds}

\item{upper_bounds}{1d vector of upper bounds}

\item{fixed_parameters}{optional list specifying values of fixed parameters,
with components "lambda","alpha_intra","alpha_inter","lambda_cov", and "alpha_cov".}

\item{bootstrap_samples}{how many bootstrap samples to compute.}
}
\value{
1d vector, the standard error of each parameter in init_par
}
\description{
Computes bootstrap standard errors for a given population dynamics model.
This function is provided for completeness, but error calculation is
integrated in the function \code{cxr_pm_fit}.
}
