% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/niche_overlap.R
\name{niche_overlap}
\alias{niche_overlap}
\title{Niche overlap between two species}
\usage{
niche_overlap(
  cxr_multifit = NULL,
  cxr_sp1 = NULL,
  cxr_sp2 = NULL,
  pair_matrix = NULL
)
}
\arguments{
\item{cxr_multifit}{cxr_pm_multifit object, with parameters for a series of species.}

\item{cxr_sp1}{cxr_pm_fit object giving the parameters from the first species.}

\item{cxr_sp2}{cxr_pm_fit object giving the parameters from the second species.}

\item{pair_matrix}{2x2 matrix with intra and interspecific interaction
coefficients between the two species.}
}
\value{
either a dataframe with as many rows as species, or a single named numeric vector,
containing niche overlap values for the MCT (modern coexistence theory) and SA (structural approach)
formulations.
}
\description{
quoting Godoy et al. (2014):
reflects the average degree to which species limit individuals of their own species relative to competitors.
Low niche overlap causes species to have greater per capita growth rates when rare than when common.
If species limit individuals of their own species and their competitors equally, then niche overlap is 1,
and coexistence is not possible unless species are otherwise identical.
At the other extreme, if species have no interspecific effects, then niche overlap is 0.
}
\details{
Niche overlap has a common functional form, in the context of Modern Coexistence Theory (MCT),
for a series of models, including those specified in table A1 of
Hart et al. (2018) Journal of Ecology 106, 1902-1909.
Other model families may not adhere to the general definition.

Furthermore, the MCT definition only accounts for competitive interactions (i.e. positive alpha coefficients
in these models). An alternative definition is given in Saavedra et al. (2017) Ecological Monographs 87,470-486.
In this 'structural approach', positive interactions are allowed. Incidentally, both approaches yield
qualitatively similar, but not equivalent, results for purely competitive matrices.

In all cases, these definitions only apply to models whose feasible equilibrium point can be described by a
linear equation (see Saavedra et al. 2017, Hart et al. 2018 for details).

This function calculates niche overlap among two or more taxa, using both the MCT and the structural formulation.
The function, as in \code{avg_fitness_diff} and \code{competitive_ability}, accepts three different parameterizations:
\itemize{
\item A cxr_pm_multifit object, from which niche overlap will be computed across all species pairs.
\item two cxr_pm_fit objects, one for each species.
\item explicit lambda and alpha values, as well as the model family from which these parameters were obtained.
}

If negative interactions are present, the MCT niche overlap will be NA.
The cxr objects may be calculated with user-defined model families. If this is the case, or
if simply a 2x2 matrix is provided, the niche overlap metrics will be calculated and
a warning will be raised.
}
\examples{
niche_overlap(pair_matrix = matrix(c(0.33,0.12,0.2,0.4),nrow = 2))

}
