% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R
\name{obs_data<-}
\alias{obs_data<-}
\alias{obs_data<-.drift_dm}
\alias{obs_data}
\alias{obs_data.drift_dm}
\alias{obs_data.fits_ids_dm}
\title{The Observed Data}
\usage{
obs_data(object, ...) <- value

\method{obs_data}{drift_dm}(object, ..., eval_model = FALSE) <- value

obs_data(object, ...)

\method{obs_data}{drift_dm}(object, ..., messaging = TRUE)

\method{obs_data}{fits_ids_dm}(object, ...)
}
\arguments{
\item{object}{an object of type \link{drift_dm} or \code{fits_ids_dm}
(see \link{load_fits_ids}).}

\item{...}{additional arguments passed down to the specific method.}

\item{value}{a \link{data.frame} which provides three columns: (1) \code{RT} for
the response times, (2) a column for boundary coding according to the
model's \code{\link[=b_coding]{b_coding()}}, (3) \code{Cond} for specifying the conditions.}

\item{eval_model}{logical, indicating if the model should be re-evaluated or
not when updating the solver settings (see \link{re_evaluate_model}).
Default is \code{FALSE}.}

\item{messaging}{logical, indicating if messages shall be displayed or not.}
}
\value{
For \code{obs_data()} a (re-assembled) \link{data.frame} of the observed data. A
message is displayed to remind the user that the returned \link{data.frame} may
be sorted differently than expected.

For \verb{obs_data<-()} the updated \link{drift_dm} object.
}
\description{
Functions to get or set the "observed data" of an object.
}
\details{
\code{obs_data()} is a generic accessor function, and \verb{obs_data<-()} is a
generic replacement function. The default methods get and set the "observed
data". Their behavior, however, may be a bit unexpected.

In \link{drift_dm} objects, the observed data are not stored as a
\link{data.frame}. Instead, any supplied observed data set is disassembled into
RTs for the upper and lower boundary and with respect to the different
conditions (ensures more speed and easier programming in the depths of the
package). Yet, \code{obs_data()} returns a \code{data.frame} for \link{drift_dm}
objects. This implies that \code{obs_data()} does not merely access
the observed data, but re-assembles it. Consequently, a returned \link{data.frame}
for the observed data is likely sorted differently than the \link{data.frame} that
was originally set to the model via \verb{obs_data<-()}. Also, when the originally
supplied data set provided more conditions than the model, the unused
conditions will not be part of the returned \link{data.frame}.

For \code{fits_ids_dm} (see \link{load_fits_ids}), the observed data are
stored as a \link{data.frame} in the general fit procedure info. This is the
\link{data.frame} that \code{obs_data()} will return. Thus, the returned \link{data.frame}
will match with the \link{data.frame} that was initially supplied to
\link{estimate_model_ids}, although with unused conditions being dropped.

In theory, it is possible to update parts of the "observed data". However,
because \code{obs_data()} returns a re-assembled \link{data.frame} for
\link{drift_dm} objects, great care has to be taken with respect to the
ordering of the argument \code{value}. A message is displayed to remind the user
that the returned \link{data.frame} may be sorted differently than expected.
}
\note{
There is only a replacement function for \link{drift_dm} objects. This is
because replacing the observed data after the model has been fitted (i.e.,
for a \code{fits_ids_dm} object) doesn't make sense.
}
\examples{
# Set some data to a model -------------------------------------------------
my_model <- dmc_dm() # DMC is pre-built and directly available
# synthetic data suitable for DMC; comes with dRiftDM
some_data <- dmc_synth_data
obs_data(my_model) <- some_data

# Extract data from a model ------------------------------------------------
head(obs_data(my_model))

# Important: ---------------------------------------------------------------
# The returned data.frame may be sorted differently than the one initially
# supplied.
some_data <- some_data[sample(1:nrow(some_data)), ] #' # shuffle the data set
obs_data(my_model) <- some_data
all.equal(obs_data(my_model), some_data)
# so don't do obs_data(my_model)["Cond"] <- ...

# Addition: ----------------------------------------------------------------
# accessor method also available for fits_ids_dm objects
# (see estimate_model_ids)
# get an exemplary fits_ids_dm object
fits <- get_example_fits_ids()
head(obs_data(fits))

}
\seealso{
\code{\link[=drift_dm]{drift_dm()}}
}
