% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_clustering.R
\name{angle_iteration}
\alias{angle_iteration}
\title{Angle-based iteration}
\usage{
angle_iteration(Y, z0, max_iter, alpha1 = 0.01, asymm)
}
\arguments{
\item{Y}{array/matrix, order-3 tensor/matrix observation}

\item{z0}{a list of vectors, initial clustering assignment; see "details"}

\item{max_iter}{integer, max number of iterations if update does not converge}

\item{alpha1}{number, substitution of degenerate core tensor; see "details"}

\item{asymm}{logic variable, if "TRUE", assume the clustering assignment differs in different modes; if "FALSE", assume all the modes share the same clustering assignment}
}
\value{
a list containing the following:

\code{z} {a list of vectors recording the estimated clustering assignment}

\code{s_deg} {logic variable, if "TRUE", degenerate estimated core tensor/matrix occurs during the iteration; if "FALSE", otherwise}
}
\description{
Angle-based iteration for multiway spherical clustering under degree-corrected tensor block model.
This function takes the tensor/matrix observation, initial clustering assignment, and a logic variable indicating the symmetry
as input. Output is the refined clustering assignment.
}
\details{
\code{z0} should be a length 2 list for matrix and length 3 list for tensor observation;
observations with non-identical dimension on each mode are only applicable with \code{asymm = T};

When the estimated core tensor has a degenerate slice, i.e., a slice with all zero elements, randomly pick an entry in the degenerate slice with value \code{alpha1}.
}
\examples{
test_data = sim_dTBM(seed = 1, imat = FALSE, asymm = FALSE, p = c(50,50,50), r = c(3,3,3),
                    core_control = "control", s_min = 0.05, s_max = 1,
                    dist = "normal", sigma = 0.5,
                    theta_dist = "pareto", alpha = 4, beta = 3/4)

initialization <- wkmeans(test_data$Y, r = c(3,3,3), asymm = FALSE)

iteration <- angle_iteration(test_data$Y, initialization$z0, max_iter = 20, asymm = FALSE)
}
