% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skcla_gb.R
\name{skcla_gb}
\alias{skcla_gb}
\title{Gradient Boosting Classifier}
\usage{
skcla_gb(
  attribute,
  slevels,
  loss = "log_loss",
  learning_rate = 0.1,
  n_estimators = 100,
  subsample = 1,
  criterion = "friedman_mse",
  min_samples_split = 2,
  min_samples_leaf = 1,
  min_weight_fraction_leaf = 0,
  max_depth = 3,
  min_impurity_decrease = 0,
  init = NULL,
  random_state = NULL,
  max_features = NULL,
  verbose = 0,
  max_leaf_nodes = NULL,
  warm_start = FALSE,
  validation_fraction = 0.1,
  n_iter_no_change = NULL,
  tol = 1e-04,
  ccp_alpha = 0
)
}
\arguments{
\item{attribute}{Target attribute name for model building}

\item{slevels}{Possible values for the target classification}

\item{loss}{Loss function to be optimized ('log_loss', 'exponential')}

\item{learning_rate}{Learning rate that shrinks the contribution of each tree}

\item{n_estimators}{Number of boosting stages to perform}

\item{subsample}{Fraction of samples to be used for fitting the individual base learners}

\item{criterion}{Function to measure the quality of a split}

\item{min_samples_split}{Minimum number of samples required to split an internal node}

\item{min_samples_leaf}{Minimum number of samples required to be at a leaf node}

\item{min_weight_fraction_leaf}{Minimum weighted fraction of the sum total of weights}

\item{max_depth}{Maximum depth of the individual regression estimators}

\item{min_impurity_decrease}{Minimum impurity decrease required for split}

\item{init}{Estimator object to initialize the model}

\item{random_state}{Random number generator seed}

\item{max_features}{Number of features to consider for best split}

\item{verbose}{Controls verbosity of the output}

\item{max_leaf_nodes}{Maximum number of leaf nodes}

\item{warm_start}{Whether to reuse solution of previous call}

\item{validation_fraction}{Proportion of training data to set aside for validation}

\item{n_iter_no_change}{Used to decide if early stopping will be used}

\item{tol}{Tolerance for early stopping}

\item{ccp_alpha}{Complexity parameter for cost-complexity pruning}
}
\value{
A Gradient Boosting classifier object

\code{skcla_gb} object
}
\description{
Implements a classifier using the Gradient Boosting algorithm.
This function wraps the GradientBoostingClassifier from Python's scikit-learn library.
}
\details{
Tree Boosting
}
\examples{
#See an example of using `skcla_gb` at this
#https://github.com/cefet-rj-dal/daltoolboxdp/blob/main/examples/skcla_gb.md
}
