% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_dsa.R
\name{run_owsa_det}
\alias{run_owsa_det}
\title{Run deterministic one-way sensitivity analysis (OWSA)}
\usage{
run_owsa_det(
  params_range,
  params_basecase,
  nsamp = 100,
  FUN,
  outcomes = NULL,
  strategies = NULL,
  progress = TRUE,
  ...
)
}
\arguments{
\item{params_range}{data.frame with 3 columns in the following order: "pars",
"min", and "max". The number of samples from this range is
determined by \code{nsamp}. "pars" are the parameters of interest and must be a subset of
the parameters from \code{params_basecase}.}

\item{params_basecase}{a named list of basecase values for input parameters needed by \code{FUN},
the user-defined function.}

\item{nsamp}{number of sets of parameter values to be generated. If \code{NULL}, 100 parameter
values are used}

\item{FUN}{function that takes the basecase in \code{params_basecase} and \code{...} to
produce the \code{outcome} of interest. The \code{FUN} must return a dataframe
where the first column are the strategy names and the rest of the columns must be outcomes.}

\item{outcomes}{string vector with the outcomes of interest from \code{FUN}
produced by \code{nsamp}}

\item{strategies}{vector of strategy names. The default \code{NULL} will use
strategy names in \code{FUN}}

\item{progress}{\code{TRUE} or \code{FALSE} for whether or not function progress
should be displayed in console.}

\item{...}{Additional arguments to user-defined \code{FUN}}
}
\value{
A list containing dataframes with the results of the sensitivity analyses.
The list will contain a dataframe for each outcome specified.
List elements can be visualized with \code{plot.owsa},
\code{owsa_opt_strat} and
\code{owsa_tornado} from \code{dampack}
}
\description{
This function runs a deterministic one-way sensitivity analysis (OWSA) on a
given function that produces outcomes.
}
\section{Details}{

\itemize{
\item \code{params_range}
\itemize{
\item "pars" are the names of the input parameters of interest. These are the parameters that will
 be varied in the deterministic sensitivity analysis. variables in "pars" column
 must be a subset of variables in \code{params_basecase}
\item "min" and "max" are the mininum and maximum values of the parameters of interest.}
}
}

