% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateWeightsFunctions.R
\name{generateWeightsHeUniform}
\alias{generateWeightsHeUniform}
\title{He uniform weight initialization}
\usage{
generateWeightsHeUniform(numUnits1, numUnits2, ...)
}
\arguments{
\item{numUnits1}{Number of units in the lower layer.}

\item{numUnits2}{Number of units in the upper layer.}

\item{...}{Additional parameters, used for parameter resolution and passed
to \code{\link{generateWeightsUniform}}.}
}
\value{
Weight matrix.
}
\description{
This function is used to generate random weights and biases using
He uniform weight initialization as described in
He et al., \url{http://arxiv.org/abs/1502.01852}.
}
\examples{
\dontrun{
data(iris)
model <- darch(Species ~ ., iris, generateWeightsFunction = "generateWeightsHeUniform")
}
}
\references{
He, Kaiming, Xiangyu Zhang, Shaoqing Ren, and Jian Sun (2015).
 "Delving Deep into Rectifiers: Surpassing Human-Level Performance on
 ImageNet Classification". In: CoRR abs/1502.01852.
 URL: http://arxiv.org/abs/1502.01852
}
\seealso{
Other weight generation functions: \code{\link{generateWeightsGlorotNormal}},
  \code{\link{generateWeightsGlorotUniform}},
  \code{\link{generateWeightsHeNormal}},
  \code{\link{generateWeightsNormal}},
  \code{\link{generateWeightsUniform}}
}

