% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.basic.stats.r
\name{gl.basic.stats}
\alias{gl.basic.stats}
\title{Calculates basic statistics for each loci (Hs, Ho, Fis etc.)}
\usage{
gl.basic.stats(x, digits = 4, verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{digits}{Number of digits that should be returned [default 4].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
Several tables and lists with all basic stats.
}
\description{
Based on function \code{\link[hierfstat]{basic.stats}}. Check ?basic.stats
for help and \code{\link[hierfstat]{basic.stats}} for details.#'
}
\examples{
if (!(requireNamespace("hierfstat", quietly = TRUE))) {
out <- gl.basic.stats(possums.gl[1:10,1:100])
}

}
\seealso{
Other basic statistics: 
\code{\link{gl.amova}()}
}
\author{
Bernd Gruber (Post to
\url{https://groups.google.com/d/forum/dartr})
}
\concept{basic statistics}
